#ifndef __DEBUG_H__
#define __DEBUG_H__

/* ===[ $RCSfile: debug.h,v $ ]===========================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2003-2005 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: debug.h,v 1.2 2005/02/03 22:13:05 cmayncvs Exp $"
 *
 *  \brief Contains generic debug macros for all modules.
 */
/* ======================================================================= */
/* ======= */
/* Defines */
/* ======= */
#ifndef INC_gdebug_h
/* debug print error levels - (from LVT gdebug.h) */
#define DBG_NONE        0       /**< No debug */
#define DBG_ALL         1       /**< All debug */
#define DBG_INFO4       2       /**< Level Informational 4 debug */
#define DBG_INFO3       3       /**< Level Informational 3 debug */
#define DBG_INFO2       4       /**< Level Informational 2 debug */
#define DBG_INFO1       5       /**< Level Informational 1 debug */
#define DBG_WARN        6       /**< Level Warning debug */
#define DBG_ERR         7       /**< Level Error debug */
#endif /* INC_gdebug_h */

#define NONE_LEVEL      (0x00)  /**< Comm no debug */
#define WARN_LEVEL      (0x01)  /**< Comm Warning level debug */
#define INFO_LEVEL      (0x02)  /**< Comm Informational level debug */
#define TRACE_LEVEL     (0x03)  /**< Comm Trace level debug */
#define PRINT_LEVEL     (0x04)  /**< Comm Print level debug */

/** Warning debug macro */
#define warn(fmt,args...)                                               \
    do {if ( MODULE_DEBUG_LEVEL >= WARN_LEVEL )                         \
    {                                                                   \
        printf(MODULE_NAME" ("__FILE__" %d) ***WARNING***: " fmt "\n",  \
            __LINE__ , ##args);                                         \
        fflush(stdout);                                                 \
    }} while (0)

/** Informational debug macro */
#define info(fmt,args...)                                   \
    do {if ( MODULE_DEBUG_LEVEL >= INFO_LEVEL )             \
    {                                                       \
        printf(MODULE_NAME" ("__FILE__" %d): " fmt "\n",    \
           __LINE__ , ##args);                              \
        fflush(stdout);                                     \
    }} while (0)

/** Trace debug macro */
#define trace(fmt,args...)                                  \
    do {if ( MODULE_DEBUG_LEVEL >= TRACE_LEVEL )            \
    {                                                       \
        printf(MODULE_NAME" ("__FILE__" %d): " fmt "\n",    \
            __LINE__ , ##args);                             \
        fflush(stdout);                                     \
    }} while (0)

/** Print debug macro */
#define print(fmt,args...)                                  \
    do {if ( MODULE_DEBUG_LEVEL >= PRINT_LEVEL )            \
    {                                                       \
        printf(fmt , ##args);                               \
        fflush(stdout);                                     \
    }} while (0)

#endif /* __DEBUG_H__ */

/*
 * End of "$Id: debug.h,v 1.2 2005/02/03 22:13:05 cmayncvs Exp $".
 */

