#ifndef __GASSERT_H__
#define __GASSERT_H__

/* ===[ $RCSfile: gassert.h,v $ ]=========================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2002-2004 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: gassert.h,v 1.2 2005/02/04 22:56:07 cmayncvs Exp $"
 *
 *  \brief Handles assert() macro vs. f_fault_write_log().
 *  \warning Do no include assert.h in your code.  Use this header file
 *      instead.
 */
/* ======================================================================= */

#include "gfault.h"

#if USE_STUBS

/* Use normal assert facilities.  */
#include <assert.h>

#define libassert(expr) assert(expr)

#else /* !USE_STUBS */
#include <stdlib.h>     /* required for __STRING() macro */
#include <errno.h>      /* required for errno */
#include <string.h>     /* required for strerror() */
#include <sys/types.h>  /* required for getpid() */
#include <unistd.h>     /* required for getpid() */

#ifdef assert
#undef assert
#endif

/**
 * Define assert() macro so that it logs a fault.  System manager normally
 * calls f_fault_initdir(), but in stand-alone testing without sysman running,
 * it still must be called.  NOTE: It is safe to call it more than once.
 */
#define assert(expr)                                                    \
    ((expr) ? 0 :                                                       \
        (f_fault_write_log("%s: %d\n%s\npid=%d (%s), errno=%d (%s)",    \
                          (int)__FILE__,  __LINE__, __STRING(expr),     \
                          getpid(), f_fault_read_pname(),               \
                          errno, strerror(errno)),                      \
         exit(0)))

/**
 * This macro works the same way as assert(), but it was designed to be called
 * from within a shared library, such as libcom.so.  The differnece is that
 * it also logs the file & line from whence we came.
 */
#define libassert(expr)                                                 \
    ((expr) ? 0 :                                                       \
        (f_fault_write_log("%s: %d (%s: %d)\n%s\npid=%d (%s), "         \
                          "errno=%d (%s)\n",                            \
                          (int)__FILE__, __LINE__, file, line,          \
                          __STRING(expr),                               \
                          getpid(), f_fault_read_pname(),               \
                          errno, strerror(errno)),                      \
         exit(0)))

#endif /* !USE_STUBS */

#endif /* __GASSERT_H__ */


/*
 * End of "$Id: gassert.h,v 1.2 2005/02/04 22:56:07 cmayncvs Exp $".
 */


