/* ===[ $RCSfile: gfault.h,v $ ]==========================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2002-2004 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: gfault.h,v 1.2 2005/02/04 22:54:57 cmayncvs Exp $"
 *
 *  \brief Fault library API.
 */
/* ======================================================================= */
#ifndef __LFAULT_H__
#define __LFAULT_H__

/* common definitions */
#ifndef OK
#define OK 0
#endif

#ifndef ERROR
#define ERROR (-1)
#endif

/* gfault definitions */
#define MAXFAULTS       8
#define FAULTLOGSIZE    255

/* fault error codes */
#define FLTERR              128
#define FLTERR_INIT         (FLTERR + 0x0)  /* Library is not initialized */
#define FLTERR_NOMEM        (FLTERR + 0x1)  /* Memory allocation failed */
#define FLTERR_MAXLOG       (FLTERR + 0x2)  /* The log is full */
#define FLTERR_INVAL        (FLTERR + 0x3)  /* Invalid argument */
#define FLTERR_CREAT        (FLTERR + 0x4)  /* Error creating the log */
#define FLTERR_OPEN         (FLTERR + 0x5)  /* Error opening the log */
#define FLTERR_READ         (FLTERR + 0x6)  /* Error reading from the log */
#define FLTERR_WRITE        (FLTERR + 0x7)  /* Error writing to the log */
#define FLTERR_CLOSE        (FLTERR + 0x8)  /* Error closing the log */
#define FLTERR_FSYNC        (FLTERR + 0x9)  /* Error synchronizing the log */
#define FLTERR_ERASE        (FLTERR + 0xA)  /* Error erasing the log */
#define FLTERR_SHMCREAT     (FLTERR + 0xB)  /* Error creating shared memory */
#define FLTERR_SEMCREAT     (FLTERR + 0xC)  /* Error creating semaphore */
#define FLTERR_SHMGET       (FLTERR + 0xD)  /* Error getting shared mem id */
#define FLTERR_SEMGET       (FLTERR + 0xE)  /* Error getting semaphore id */
#define FLTERR_SEMLOCK      (FLTERR + 0xF)  /* Error locking semaphore */
#define FLTERR_SEMUNLOCK    (FLTERR + 0x10) /* Error unlocking semaphore */

/* Handy f_fault_dump() dest macros */
#define DUMP_TO_CONSOLE                 0
#define DUMP_TO_FILE                    1
#define DUMP_TO_BUFFER                  2

/* fault function prototypes */
extern int f_fault_initdir(char *dir);
extern int f_fault_init(void);
extern void f_fault_write_log(char *fmt, ...);
extern int f_fault_erase(void);
extern int f_fault_dump(char dest, ...);
extern int f_fault_get_count(void);
extern void f_fault_set_debug_level(int level);
extern char *f_fault_read_pname(void);

/* FAULT Logger */
#define LOG_FAULT(fmt, args...) \
        f_fault_write_log("%s: %d\n" fmt, (int)__FILE__,  __LINE__, ##args)

#endif /* __LFAULT_H__ */


/*
 * End of "$Id: gfault.h,v 1.2 2005/02/04 22:54:57 cmayncvs Exp $".
 */


