#ifndef BUF_H
#define BUF_H

/* ===[ $RCSfile: buf.h,v $ ]=============================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2002-2004 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: buf.h,v 1.2 2005/02/04 23:05:08 cmayncvs Exp $"
 *
 *  \brief Linux comm library buffer API.
 */
/* ======================================================================= */
#include <stdio.h>

/** Macro to pass file & line # from caller to _buf_append() library function */
#define buf_append(b, data, len)    _buf_append(b, data, len, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _buf_data() library function */
#define buf_data(b)                 _buf_data(b, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _buf_join() library function */
#define buf_join(head, tail)        _buf_join(head, tail, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _buf_dup() library function */
#define buf_dup(b)                  _buf_dup(b, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _buf_free() library function */
#define buf_free(b)                 _buf_free(b, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _buf_queue() library function */
#define buf_queue(q,b)              _buf_queue(&(q), (b), __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _buf_dequeue() library function */
#define buf_dequeue(q)              _buf_dequeue(&(q), __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _buf_nprint() library function */
#define buf_nprint(b, num)          _buf_nprint(b, num, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _buf_print() library function */
#define buf_print(b)                _buf_print(b, __FILE__, __LINE__)

/** Maximum of A and B. */
#define MAX(a,b) ((a) > (b)) ? (a) : (b)

struct buf;
/** \brief Typedef for pointer to buffer */
typedef struct buf * buf_t;
/** \brief Typedef for pointer to a queue of buffers */
typedef struct buf * buf_q;

buf_t
_buf_append (buf_t b, const void *vdata, size_t length, const char *file, int line);

void *
_buf_data (buf_t b, const char *file, int line);

size_t
buf_length (buf_t);

buf_t
_buf_join (buf_t head, buf_t tail, const char *file, int line);

buf_t
_buf_dup (buf_t b, const char *file, int line);

buf_t
_buf_free (buf_t b, const char *file, int line);

unsigned int
buf_get_tag (buf_t b);

void
buf_set_tag (buf_t b, unsigned int tag);

unsigned char
buf_get_val (buf_t b, unsigned int index);

void
buf_set_val (buf_t b, unsigned int index, unsigned char val);

void
_buf_queue (buf_q *q, buf_t b, const char *file, int line);

buf_t
_buf_dequeue (buf_q *q, const char *file, int line);

void
_buf_nprint (buf_t b, size_t num_bytes, const char *file, int line);

void
_buf_print (buf_t b, const char *file, int line);

void
print_hex_data (unsigned char *d, int l);

void
buf_print_stats (FILE *f);

unsigned int
buf_queue_length (buf_q q);

#endif /* BUF_H */


/*
 * End of "$Id: buf.h,v 1.2 2005/02/04 23:05:08 cmayncvs Exp $".
 */


