#ifndef __C_CONFIG_H__
#define __C_CONFIG_H__

/* ===[ $RCSfile: c_config.h,v $ ]========================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2002-2004 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: c_config.h,v 1.9 2005/03/11 21:56:35 cmayncvs Exp $"
 *
 *  \brief Contains the Comm parameters API .
 */
/* ======================================================================= */

/* Defines */
/** Macro to pass file & line # from caller to _c_config_read() library function */
#define c_config_read(rec, dest, def, size)             \
    _c_config_read(rec, dest, def, size, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _c_config_read_defaults() library function */
#define c_config_read_defaults(rec, dest, def, size)    \
    _c_config_read_defaults(rec, dest, def, size, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _c_config_write() library function */
#define c_config_write(rec, src, size)                  \
    _c_config_write(rec, src, size, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _c_config_commit() library function */
#define c_config_commit()       _c_config_commit(__FILE__, __LINE__)

/* API */
void *_c_config_read(const char *record, void *dest, const void *defaults,
    size_t size, const char *file, int line);
void *_c_config_read_defaults(const char *record, void *dest,
    const void *defaults, size_t size, const char *file, int line);
void _c_config_write(const char *record, const void *src, size_t size,
    const char *file, int line);
void _c_config_commit(const char *file, int line);
void c_config_set_debug_level(int level);


/* common definitions */
#ifndef ERROR
 /** Definition for config library function call errors. */
 #define ERROR (-1)
#endif

#ifndef OK
 /** Definition for config library function call success. */
 #define OK 0
#endif
/** Gtech run-time configuration data files reside here. */
#define  ESPAD_CONFIG_DIR           "/etc/gtech/config"
/** Gtech site-specific default configuration data files reside here. */
#define  ESPAD_CONFIG_DEFAULT_DIR   "/etc/gtech/config/default"
/** The semaphore key used by the config library when writing parameters. */
#define  CFG_SEMKEY 0x4744
/** The maximum configuration file name length. */
#define  MAXREC_FILESIZE      4
/** The maximum configuration file size. */
#define  MAXREC_RECSIZE       512

/* Names from Altura gpaths.h */
/** Root directory of Gtech configuration files */
#define G_ROOT_DIR              ESPAD_CONFIG_DIR
/** Default configuration file directory. */
#define G_CONFIG_DEFAULT_DIR    ESPAD_CONFIG_DEFAULT_DIR
/** Primary configuration file directory. */
#define G_CONFIG_PRIMARY_DIR    ESPAD_CONFIG_DIR
/** Secondary configuration file directory. (Not applicable for ESPAD) */
#define G_CONFIG_SHADOW_DIR     ESPAD_CONFIG_DIR
/** Tertiary configuration file directory. (Not applicable for ESPAD) */
#define G_CONFIG_BACKUP_DIR     ESPAD_CONFIG_DIR

/* From Altura /inc/gconfig.h */
#define CFGERR            0                 /**< Config library error base */
#define CFGERR_INIT       (CFGERR + 0x0)    /**< The library is not initialized */
#define CFGERR_NAMELONG   (CFGERR + 0x1)    /**< The record name is too long */
#define CFGERR_CRC        (CFGERR + 0x2)    /**< CRC mismatch */
#define CFGERR_NOMEM      (CFGERR + 0x3)    /**< Memory allocation failed */
#define CFGERR_CREAT      (CFGERR + 0x4)    /**< Error creating config file */
#define CFGERR_OPEN       (CFGERR + 0x5)    /**< Error opening config file */
#define CFGERR_CLOSE      (CFGERR + 0x6)    /**< Error closing config file */
#define CFGERR_READ       (CFGERR + 0x7)    /**< Error reading from config file */
#define CFGERR_WRITE      (CFGERR + 0x8)    /**< Error writing to config file */
#define CFGERR_FSYNC      (CFGERR + 0x9)    /**< Error synchronizing config file to disk */
#define CFGERR_COPY       (CFGERR + 0xA)    /**< Error copying from source to destination */
#define CFGERR_COPY_O2C   (CFGERR + 0xB)    /**< Error copying old config file to current */
#define CFGERR_MOVE       (CFGERR + 0xC)    /**< Error moving from source to destination */
#define CFGERR_MOVE_N2C   (CFGERR + 0xD)    /**< Error moving new config file to current */
#define CFGERR_MOVE_C2O   (CFGERR + 0xE)    /**< Error moving current config file to old */
#define CFGERR_REMOVE     (CFGERR + 0xF)    /**< Error removing a config file */
#define CFGERR_REM_NEW    (CFGERR + 0x10)   /**< Error removing the new config file */
#define CFGERR_REM_CUR    (CFGERR + 0x11)   /**< Error removing the current config file */
#define CFGERR_REM_OLD    (CFGERR + 0x12)   /**< Error removing the old config file */
#define CFGERR_REM_DIR    (CFGERR + 0x13)   /**< Error removing a config directory */
#define CFGERR_NOOLDCFG   (CFGERR + 0x14)   /**< No old config data during roll back */
#define CFGERR_SHMCREAT   (CFGERR + 0x15)   /**< Error creating shared memory */
#define CFGERR_SEMCREAT   (CFGERR + 0x16)   /**< Error creating semaphore */
#define CFGERR_SHMGET     (CFGERR + 0x17)   /**< Error getting shared memory id */
#define CFGERR_SEMGET     (CFGERR + 0x18)   /**< Error getting sem */
#define CFGERR_SEMLOCK    (CFGERR + 0x19)   /**< Error locking sem */
#define CFGERR_SEMUNLOCK  (CFGERR + 0x1A)   /**< Error unlocking semaphore */

/** \brief From Altura /gdebug/gdebug.h.  NOTE: Must link to libgfault.so */
extern int gerrno;    /* already in gfault.c */

/*****************  TEST CODE  ***************************/
/** Maximum field length. */
#define    MAX_FIELD_LEN   32
/** Typedef for test structure */
typedef struct
{
  char test_str1[MAX_FIELD_LEN+1];  /**< Test string 1 */
  char test_str2[MAX_FIELD_LEN+1];  /**< Test string 2 */
  char test_str3[MAX_FIELD_LEN+1];  /**< Test string 3 */
  char test_str4[MAX_FIELD_LEN+1];  /**< Test string 4 */
} testcfg_struct;
/** Test structure */
static const testcfg_struct testcfg_defaults = {
 "ESPAD",
 "DROP 1",
 "Poll_tm",
 "END-TEST",
};
/************* END  TEST CODE ***************************/



#endif /* __C_CONFIG_H__ */

/*
 * End of "$Id: c_config.h,v 1.9 2005/03/11 21:56:35 cmayncvs Exp $"
 */
