#ifndef FDH
#define FDH

/* ===[ $RCSfile: fd.h,v $ ]==============================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2002-2004 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: fd.h,v 1.2 2005/02/04 23:05:08 cmayncvs Exp $"
 *
 *  \brief Linux comm library file descriptor API.
 */
/* ======================================================================= */

/** Macro to pass file & line # from caller to _fd_add() library function */
#define fd_add(fd, proc, ptr)   _fd_add(fd, proc, ptr, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _fd_remove() library function */
#define fd_remove(fd)           _fd_remove(fd, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _fd_select() library function */
#define fd_select()             _fd_select(__FILE__, __LINE__)
/** Macro to pass file & line # from caller to _fd_select_with_timeout() library function */
#define fd_select_with_timeout(msec)    _fd_select_with_timeout(msec, __FILE__, __LINE__)

void
_fd_add (int fd, void (*proc)(int, void*), void *ptr, const char *file, int line);

void
_fd_remove (int fd, const char *file, int line);

void
_fd_select (const char *file, int line);

int 
_fd_select_with_timeout (unsigned int msec, const char *file, int line);


void
fd_print_stats (FILE *f);

#endif /* FDH */


/*
 * End of "$Id: fd.h,v 1.2 2005/02/04 23:05:08 cmayncvs Exp $".
 */


