/*  =======================================================================
 *
 *  "$Id: lc_timer.h,v 1.2 2005/02/15 21:02:02 cmayncvs Exp $"
 *
 *   This item is the property of GTECH Corporation, West Greenwich,
 *   Rhode Island, and contains confidential and trade secret information.
 *   It may not be transferred from the custody or control of GTECH except
 *   as authorized in writing by an officer of GTECH.  Neither this item
 *   nor the information it contains may be used, transferred, reproduced,
 *   published, or disclosed, in whole or in part, and directly or
 *   indirectly, except as expressly authorized by an officer of GTECH,
 *   pursuant to written agreement.
 *
 *   Copyright (c) 2002 GTECH Corporation.  All rights reserved.
 *
 *  ======================================================================= */

/** \file lc_timer.h
 *
 *  \brief Header file for GTECH Linux Comm timers functionality.
 *
 *  This file defines the interface between application programs
 *  requiring timer services, and the library functions that provide them.
 */

/** \def LC_MINIMUM_MSECS
 *
 *  The minimum timer value is 0 seconds plus LC_MINIMUM_MSECS.
 *    Any timer started with less than this minimum will be
 *    internally adjust upwards.
 */
#define LC_MINIMUM_MSECS   10    /* 10 mille-secs */

/** \typedef lc_timer_user_func_t
 *
 *   define a type to hold pointer to user function that can be
 *   called upon timer expiration.
 */
typedef void (*lc_timer_user_func_t)(void *user_arg);

/** \typedef lc_timer_cookie_t
 *
 *   An opaque handle returned by \c lc_timer_start()
 */
typedef unsigned long lc_timer_cookie_t;

/** value of type lc_timer_cookie_t indicating failure */
#define LC_TIMER_COOKIE_FAIL  ((lc_timer_cookie_t)0)

/*
 *  Start a timer that will call the \c handler upon expiration.
 *   Returns NULL on failure, else a valid cookie.
 */
lc_timer_cookie_t   lc_timer_start(unsigned long msecs,
                                   lc_timer_user_func_t handler,
                                   void *user_arg_data);

/*
 *  cancel a previously started timer.  Returns 0 on success, else -1.
 */
int                 lc_timer_cancel(lc_timer_cookie_t tcookie);

/*
 *   Temporarily block calls to any functions due to timer expiration.
 *   (Use to implement protected code regions, for example.)
 *   NOTE:  block/unblock does NOT nest.  Also note that timers continue
 *   to run.  All functions will be called once unblocked.
 *
 *   Also note that lc_timer_start() and lc_timer_cancel() may internally
 *   use the block/unblock functions, and that these two do not nest.
 *   (Programmers should assume that calling lc_timer_start() or
 *   lc_timer_cancel() while under a block will release the block.)
 */
void                lc_timer_block(void);

/*
 *   Unblock execution of functions called due to timer expiration.
 */
void                lc_timer_unblock(void);

/*
 *  End of "$Id: lc_timer.h,v 1.2 2005/02/15 21:02:02 cmayncvs Exp $"
 */
