#ifndef LISTH
#define LISTH

/* ===[ $RCSfile: list.h,v $ ]============================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2002-2004 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: list.h,v 1.2 2005/02/04 23:05:08 cmayncvs Exp $"
 *
 *  \brief Linux comm library list API.
 */
/* ======================================================================= */

/** Macro to pass file & line # from caller to _cons() library function */
#define cons(atom, l)               _cons(atom, l, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _member() library function */
#define member(atom, l, equal)      _member(atom, l, equal, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _nthcdr() library function */
#define nthcdr(n, l)                _nthcdr(n, l, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _nth() library function */
#define nth(n, l)                   _nth(n, l, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _acons() library function */
#define acons(key, datum, alist)    _acons(key, datum, alist, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _assoc() library function */
#define assoc(key, alist, equal)    _assoc(key, alist, equal, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _destroy_alist() library function */
#define destroy_alist(alist, kd)    _destroy_alist(alist, kd, __FILE__, __LINE__)

struct cell;
/** Typedef of a list */
typedef struct cell * list;

list
_cons (void *, list, const char *file, int line);

void *
car (list);

list
cdr (list);

list
cdrf (list);

list
append (list, list);

void
mapcar (void (*)(void *), list);

list
_member (void *, list, int (*)(void *, void *), const char *file, int line);

list
removef (void *atom, list l, int (*equal)(void *, void*), void (*destroy_atom)(void *));

void *
_nthcdr (int n, list l, const char *file, int line);

void *
_nth (int, list, const char *file, int line);

void
destroy (void *);

list
_acons (void *key, void *datum, list alist, const char *file, int line);

list
_assoc (void *key, list alist, int (*equal)(void *, void *), const char *file, int line);

void
_destroy_alist (list alist, void (*destroy_kd)(void *, void *), const char *file, int line);

void
list_print_stats (FILE *f);

#endif /* LISTH */


/*
 * End of "$Id: list.h,v 1.2 2005/02/04 23:05:08 cmayncvs Exp $".
 */


