#ifndef MQH
#define MQH

/* ===[ $RCSfile: mq.h,v $ ]==============================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2002-2004 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: mq.h,v 1.2 2005/02/04 23:05:08 cmayncvs Exp $"
 *
 *  \brief Linux comm library message queue API.
 */
/* ======================================================================= */

/**Maximum length message that can be sent on a queue. */
#define MAX_MESSAGE_LENGTH 4096

/** Restart interrupted system calls. */
#define WITH_RESTART(s) ({int __rt; while (((__rt=(s)) == -1) && (errno == EINTR)); __rt;})

/** Macro to pass file & line # from caller to _mq_create() library function */
#define mq_create(name)             _mq_create(name, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _mq_destroy() library function */
#define mq_destroy()                _mq_destroy(__FILE__, __LINE__)
/** Macro to pass file & line # from caller to _mq_write() library function */
#define mq_write(dest, b)           _mq_write(dest, b, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _mq_broadcast() library function */
#define mq_broadcast(b)             _mq_broadcast(b, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _mq_read() library function */
#define mq_read()                   _mq_read(__FILE__, __LINE__)
/** Macro to pass file & line # from caller to _mq_peek() library function */
#define mq_peek()                   _mq_peek(__FILE__, __LINE__)
/** Macro to pass file & line # from caller to _mq_read_without_restart() library function */
#define mq_read_without_restart()   _mq_read_without_restart(__FILE__, __LINE__)
/** Macro to pass file & line # from caller to _mq_sync_with() library function */
#define mq_sync_with(name)          _mq_sync_with(name, __FILE__, __LINE__)

void
_mq_create (char *mq_name, const char *file, int line);

int
mq_get_socket (void);

char *
mq_local_name (void);

void
_mq_destroy (const char *file, int line);

buf_t
_mq_write (char *mq_dest, buf_t b, const char *file, int line);

buf_t
_mq_broadcast (buf_t b, const char *file, int line);

buf_t
_mq_read (const char *file, int line);

int
_mq_peek (const char *file, int line);

void
mq_print_stats (FILE *f);

buf_t
_mq_read_without_restart (const char *file, int line);

void
_mq_sync_with (char *name, const char *file, int line);

int
mq_is_a_queue (const char *name);

#endif /* MQH */


/*
 * End of "$Id: mq.h,v 1.2 2005/02/04 23:05:08 cmayncvs Exp $".
 */


