#ifndef MSGH
#define MSGH

/* ===[ $RCSfile: msg.h,v $ ]=============================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2002-2004 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: msg.h,v 1.2 2005/02/04 23:05:08 cmayncvs Exp $"
 *
 *  \brief Linux comm library messages API.
 */
/* ======================================================================= */

/** Macro to pass file & line # from caller to _msg_create() library function */
#define msg_create(source, dest, type)          \
    _msg_create(source, dest, type, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _msg_add_field() library function */
#define msg_add_field(msg, field, data, len)    \
    _msg_add_field(msg, field, data, len, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _msg_get_type() library function */
#define msg_get_type(msg)           _msg_get_type(msg, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _msg_get_dest() library function */
#define msg_get_dest(msg)           _msg_get_dest(msg, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _msg_get_source() library function */
#define msg_get_source(msg)         _msg_get_source(msg, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _msg_get_field() library function */
#define msg_get_field(msg, field, len)          \
    _msg_get_field(msg, field, len, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _msg_aref() library function */
#define msg_aref(b, index, name, data)          \
    _msg_aref(b, index, name, data, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _msg_print() library function */
#define msg_print(b)                _msg_print(b, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _msg_is_from() library function */
#define msg_is_from(msg, from)      _msg_is_from(msg, from, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _msg_is_type() library function */
#define msg_is_type(msg, type)      _msg_is_type(msg, type, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _msg_dispatch_proc() library function */
#define msg_dispatch_proc(type, proc)           \
    _msg_dispatch_proc(type, proc, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _msg_default_dispatch_proc() library function */
#define msg_default_dispatch_proc(proc)         \
    _msg_default_dispatch_proc(proc, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _msg_dispatch() library function */
#define msg_dispatch(msg)           _msg_dispatch(msg, __FILE__, __LINE__)

buf_t
_msg_create (char *source, char *dest, char *type, const char *file, int line);

buf_t
_msg_add_field (buf_t msg, char *field, char *data, unsigned int length, const char *file, int line);

char *
_msg_get_type (buf_t msg, const char *file, int line);

char *
_msg_get_dest (buf_t msg, const char *file, int line);

char *
_msg_get_source (buf_t msg, const char *file, int line);

char *
_msg_get_field (buf_t msg, char *field, unsigned int *length, const char *file, int line);

unsigned int
_msg_aref (buf_t b, unsigned int index, char **name, char **data, const char *file, int line);

void
_msg_print (buf_t b, const char *file, int line);

int
_msg_is_from (buf_t msg, char *from, const char *file, int line);

int
_msg_is_type (buf_t msg, char *type, const char *file, int line);

void
_msg_dispatch_proc (char *type, void (*proc)(buf_t), const char *file, int line);

void
_msg_default_dispatch_proc (void (*proc)(buf_t, const char*, int), const char *file, int line);

void
_msg_dispatch (buf_t msg, const char *file, int line);

void
msg_print_stats (FILE *f);

#endif /* MSGH */


/*
 * End of "$Id: msg.h,v 1.2 2005/02/04 23:05:08 cmayncvs Exp $".
 */


