#ifndef STATSH
#define STATSH

/* ===[ $RCSfile: stats.h,v $ ]===========================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2002-2004 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: stats.h,v 1.3 2005/02/14 02:00:22 cmayncvs Exp $"
 *
 *  \brief Linux comm library list API.
 */
/* ======================================================================= */

/** Macro to pass file & line # from caller to _stats_init() library function */
#define stats_init()            _stats_init(__FILE__, __LINE__)
/** Macro to pass file & line # from caller to _stats_add_proc() library function */
#define stats_add_proc(proc)    _stats_add_proc(proc, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _stats_get() library function */
#define stats_get(proc,buf,cnt) _stats_get(proc, buf, cnt, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _get_pid() library function */
#define get_pid(pname)          _get_pid(pname, __FILE__, __LINE__)

void
_stats_init (const char *file, int line);

void
_stats_add_proc (void (*proc)(FILE *), const char *file, int line);

void
stats_add_struct_writer (void *buf, int length);

int
_stats_get (char *process, void *buf, int count, const char *file, int line);

long
_get_pid (char *pname, const char *file, int line);

#endif /* STATSH */


/*
 * End of "$Id: stats.h,v 1.3 2005/02/14 02:00:22 cmayncvs Exp $".
 */


