#ifndef STRH
#define STRH

/* ===[ $RCSfile: str.h,v $ ]=============================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2002-2005 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: str.h,v 1.3 2005/04/09 00:23:48 cmayncvs Exp $"
 *
 *  \brief Linux comm library string API.
 */
/* ======================================================================= */

/** Macro to pass file & line # from caller to _str_split() library function */
#define str_split(str, sep)         _str_split(str, sep, __FILE__, __LINE__)
/** Macro to pass file & line # from caller to _str_split_dup() library function */
#define str_split_dup(str, sep)     _str_split_dup(str, sep, __FILE__, __LINE__)

list
_str_split (char *str, char *sep, const char *file, int line);

list
_str_split_dup (char *str, char *sep, const char *file, int line);

char *
str_upper (char *s);

char *
str_chomp (char *s);

char *
sec2str(unsigned long secs);

void
print_text(const unsigned char *txt, unsigned int len);

void
print_textz(const unsigned char *txt);
#endif /* STRH */


/*
 * End of "$Id: str.h,v 1.3 2005/04/09 00:23:48 cmayncvs Exp $".
 */


