#ifndef TIMERH
#define TIMERH

/* ===[ $RCSfile: timer.h,v $ ]===========================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2002-2004 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: timer.h,v 1.2 2005/02/04 23:05:08 cmayncvs Exp $"
 *
 *  \brief Linux comm library timer API.
 */
/* ======================================================================= */

#include "lc_timer/lc_timer.h"

/** Timer typedef */
typedef lc_timer_cookie_t timer;
/** Macro to pass file & line # from caller to _timer_start() library function */
#define timer_start(msec, id)   _timer_start(msec, id, __FILE__, __LINE__)

timer
_timer_start (unsigned long msec, unsigned long id, const char *file, int line);

timer
timer_stop (timer t);

void
timer_print_stats (FILE *f);

#endif /* TIMERH */


/*
 * End of "$Id: timer.h,v 1.2 2005/02/04 23:05:08 cmayncvs Exp $".
 */


