/* This file was generated by mib2c and is intended for use as a mib module
   for the ucd-snmp snmpd agent. */


#ifdef IN_UCD_SNMP_SOURCE
/* If we're compiling this file inside the ucd-snmp source tree */


/* This should always be included first before anything else */
#include <config.h>


/* minimal include directives */
#include "mibincl.h"
#include "util_funcs.h"


#else /* !IN_UCD_SNMP_SOURCE */


#include <ucd-snmp/ucd-snmp-config.h>
#include <ucd-snmp/ucd-snmp-includes.h>
#include <ucd-snmp/ucd-snmp-agent-includes.h>


#endif /* !IN_UCD_SNMP_SOURCE */


#include <linux/reboot.h>
#include <pthread.h>

#include "diag.h"

void     *reset_task(void *arg);


/*
 * diag_variables_oid:
 *   this is the top level oid that we want to register under.  This
 *   is essentially a prefix, with the suffix appearing in the
 *   variable below.
 */


oid diag_variables_oid[] = { 1,3,6,1,4,1,638,2,2,9,2 };


/*
 * variable2 diag_variables:
 *   this variable defines function callbacks and type return information
 *   for the diag mib section
 */


struct variable2 diag_variables[] = {
/*  magic number        , variable type , ro/rw , callback fn  , L, oidsuffix */
#define   ESPADDIAGRESET        1
  { ESPADDIAGRESET      , ASN_INTEGER   , RWRITE, var_diag, 1, { 1 } },

};
/*    (L = length of the oidsuffix) */


/*
 * init_diag():
 *   Initialization routine.  This is called when the agent starts up.
 *   At a minimum, registration of your variables should take place here.
 */
void init_diag(void) {


  /* register ourselves with the agent to handle our mib tree */
  REGISTER_MIB("diag", diag_variables, variable2,
               diag_variables_oid);

  /* place any other initialization junk you need here */
}


/*
 * var_diag():
 *   This function is called every time the agent gets a request for
 *   a scalar variable that might be found within your mib section
 *   registered above.  It is up to you to do the right thing and
 *   return the correct value.
 *     You should also correct the value of "var_len" if necessary.
 *
 *   Please see the documentation for more information about writing
 *   module extensions, and check out the examples in the examples
 *   and mibII directories.
 */
unsigned char *
var_diag(struct variable *vp,
                oid     *name,
                size_t  *length,
                int     exact,
                size_t  *var_len,
                WriteMethod **write_method)
{


  /* variables we may use later */
  static long long_ret;


  if (header_generic(vp,name,length,exact,var_len,write_method)
                                  == MATCH_FAILED ) {
    return NULL;
  }


  /*
   * this is where we do the value assignments for the mib results.
   */
  switch(vp->magic) {


    case ESPADDIAGRESET:
        *write_method = write_esPadDiagReset;
        long_ret = 0;
        return (unsigned char *) &long_ret;


    default:
      ERROR_MSG("");
  }
  return NULL;
}





int
write_esPadDiagReset(int      action,
            u_char   *var_val,
            u_char   var_val_type,
            size_t   var_val_len,
            u_char   *statP,
            oid      *name,
            size_t   name_len)
{
  int retval;
  static long long_ret;
  static pthread_t reset_thread;

  switch ( action ) {
        case RESERVE1:
          if (var_val_type != ASN_INTEGER){
              fprintf(stderr, "write to esPadDiagReset not ASN_INTEGER\n");
              return SNMP_ERR_WRONGTYPE;
          }
          if (var_val_len > sizeof(long_ret)){
              fprintf(stderr,"write to esPadDiagReset: bad length\n");
              return SNMP_ERR_WRONGLENGTH;
          }
          break;

        case RESERVE2:
          break;

        case FREE:
          break;

        case ACTION:
          break;

        case UNDO:
          break;

        case COMMIT:
          /* Things are working well, so it's now safe to make the change
          permanently.  Make sure that anything done here can't fail! */
          printf("In write_esPadDiagReset() creating reset thread\n");
          retval = pthread_create(&reset_thread, NULL, reset_task, (void *)NULL);
          break;
  }
  return SNMP_ERR_NOERROR;
}



void *reset_task(void *arg)
{
    printf("Entering reset_task");

    printf("reset_task - waiting 5 seconds\n");
    sleep(5);

    system("/sbin/reboot");
    exit(0);
}
