/*
 * include important headers
 */
#include <net-snmp/net-snmp-config.h>
#include <stdio.h>

#if HAVE_STDLIB_H
#include <stdlib.h>
#endif
#if HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif
#include <fcntl.h>

/*
 * needed by util_funcs.h
 */
#if TIME_WITH_SYS_TIME
# ifdef WIN32
#  include <sys/timeb.h>
# else
#  include <sys/time.h>
# endif
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#if HAVE_WINSOCK_H
#include <winsock.h>
#endif
#if HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif

#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>

/*
 * header_generic() comes from here
 */
#include "util_funcs.h"


#define ALLOCATE
#include "espad.h"
#undef ALLOCATE

#define DEBUG 1
unsigned char temp_buffer[1000];
int temp_int[10];

enum meminfo_row { meminfo_main = 0,
                   meminfo_swap };

enum meminfo_col { meminfo_total = 0, meminfo_used, meminfo_free,
                   meminfo_shared, meminfo_buffers, meminfo_cached
};


/*
 * espad_variables_oid:
 *   this is the top level oid that we want to register under.  This
 *   is essentially a prefix, with the suffix appearing in the
 *   variable below.
 */
oid espad_variables_oid[] = { 1,3,6,1,4,1,638,2,2,1 };

/*
 * variable2 espad_variables:
 *   this variable defines function callbacks and type return information
 *   for the espad mib section
 */
struct variable2 espad_variables[] = {
/*  magic number        , variable type , ro/rw , callback fn  , L, oidsuffix */
#define   HARDPROFILETYPE       1
  { HARDPROFILETYPE     , ASN_INTEGER   , RONLY , var_espad, 1, { 1 } },
#define   HARDPROFILEDESCR      2
  { HARDPROFILEDESCR    , ASN_OCTET_STR , RONLY , var_espad, 1, { 2 } },
#define   HARDPROFILESTATUS     3
  { HARDPROFILESTATUS   , ASN_INTEGER   , RONLY , var_espad, 1, { 3 } },
#define   HARDPROFILETIME       4
  { HARDPROFILETIME     , ASN_OCTET_STR , RWRITE, var_espad, 1, { 4 } },
#define   HARDPROFILEDATE       5
  { HARDPROFILEDATE     , ASN_OCTET_STR , RWRITE, var_espad, 1, { 5 } },
#define   HARDPROFILEROMID      6
  { HARDPROFILEROMID    , ASN_OCTET_STR , RONLY , var_espad, 1, { 6 } },
#define   HARDPROFILECPUID      7
  { HARDPROFILECPUID    , ASN_OCTET_STR , RONLY , var_espad, 1, { 7 } },
#define   HARDPROFILEDESCHIP    8
  { HARDPROFILEDESCHIP  , ASN_INTEGER   , RONLY , var_espad, 1, { 8 } },
#define   HARDPROFILERAMSIZE    9
  { HARDPROFILERAMSIZE  , ASN_INTEGER   , RONLY , var_espad, 1, { 9 } },
#define   HARDPROFILEFLASHSIZE  10
  { HARDPROFILEFLASHSIZE, ASN_INTEGER   , RONLY , var_espad, 1, { 10 } },
#define   HARDPROFILETRAPENABLE  11
  { HARDPROFILETRAPENABLE, ASN_INTEGER   , RWRITE, var_espad, 1, { 11 } },
#define   HARDPROFILECOLDSTARTTRAPACK  12
  { HARDPROFILECOLDSTARTTRAPACK, ASN_INTEGER   , RWRITE, var_espad, 1, { 12 } },
#define   HARDPROFILECOLDSTARTTRAPFREQUENCY  13
  { HARDPROFILECOLDSTARTTRAPFREQUENCY, ASN_INTEGER   , RWRITE, var_espad, 1, { 13 } },
#define   HARDPROFILECFGCHECKSUM  14
  { HARDPROFILECFGCHECKSUM, ASN_INTEGER   , RONLY , var_espad, 1, { 14 } },

};
/*    (L = length of the oidsuffix) */


int first_time = 1;

/*
 * init_espad():
 *   Initialization routine.  This is called when the agent starts up.
 *   At a minimum, registration of your variables should take place here.
 */
void init_espad(void)
{
   int i;

   if (!first_time)
      return;

   first_time = 0;

   /* register ourselves with the agent to handle our mib tree */
   REGISTER_MIB("espad", espad_variables, variable2,
                espad_variables_oid);

   /* place any other initialization junk you need here */

   /* Initialize hardware profile (hardProfile group) information */
   memset(&hard_profile, 0, sizeof(HARDPROFILE));

   hard_profile.type = (ushort)VAL_hardProfileType_termPOSESPad;

   strncpy(hard_profile.description, "ESPAD Terminal", sizeof("ESPAD Terminal") );

   strncpy(hard_profile.romid, "XXXX", sizeof("XXXX") );

   strncpy(hard_profile.cpu_id, "powerpc", sizeof("powerpc") );

   hard_profile.ram_size = memory(meminfo_total);
   hard_profile.flash_size = 1024L;
   hard_profile.status = (ushort)VAL_hardProfileStatus_running;
   hard_profile.trap_enable = (char)VAL_hardProfileTrapEnable_enable;
   hard_profile.checksum = 5L;
   hard_profile.ColdStartTrapFrequency = 1L;
   hard_profile.ColdStartTrapAck = FALSE;
   hard_profile.DESChip = VAL_hardProfileDESChip_no;


   /* init cold start acknowledgement flag */
   hard_profile.ColdStartTrapAck = VAL_hardProfileColdStartTrapAck_no;


   init_polltable();
   init_diag();
}


/*
 * var_espad():
 *   This function is called every time the agent gets a request for
 *   a scalar variable that might be found within your mib section
 *   registered above.  It is up to you to do the right thing and
 *   return the correct value.
 *     You should also correct the value of "var_len" if necessary.
 *
 *   Please see the documentation for more information about writing
 *   module extensions, and check out the examples in the examples
 *   and mibII directories.
 */
unsigned char *
var_espad(struct variable *vp,
                oid     *name,
                size_t  *length,
                int     exact,
                size_t  *var_len,
                WriteMethod **write_method)
{


  /* variables we may use later */
  static long long_ret;
  int i;


  if (header_generic(vp,name,length,exact,var_len,write_method)
                                  == MATCH_FAILED )
    return NULL;


  /*
   * this is where we do the value assignments for the mib results.
   */
  switch(vp->magic) {


    case HARDPROFILETYPE:

        long_ret = (u_long)hard_profile.type;
        return (unsigned char *) &long_ret;

    case HARDPROFILEDESCR:

        *var_len = strlen(hard_profile.description);
        return (unsigned char *) hard_profile.description;

    case HARDPROFILESTATUS:

        long_ret = hard_profile.status;
        return (unsigned char *) &long_ret;

    case HARDPROFILETIME:
        *write_method = write_hardProfileTime;
        *var_len = strlen(hard_profile.time);
        return (unsigned char *) hard_profile.time;

    case HARDPROFILEDATE:
        *write_method = write_hardProfileDate;
        *var_len = strlen(hard_profile.date);
        return (unsigned char *) hard_profile.date;

    case HARDPROFILEROMID:
        *var_len = strlen(hard_profile.romid);
        return (unsigned char *)hard_profile.romid;

    case HARDPROFILECPUID:
        *var_len = strlen(hard_profile.cpu_id);
        return (unsigned char *)hard_profile.cpu_id;

    case HARDPROFILEDESCHIP:
        long_ret = hard_profile.DESChip;
        return (unsigned char *) &long_ret;

    case HARDPROFILERAMSIZE:
        long_ret = (u_long)hard_profile.ram_size;
        return (unsigned char *) &long_ret;

    case HARDPROFILEFLASHSIZE:
        long_ret = (u_long)hard_profile.flash_size;
        return (unsigned char *) &long_ret;

    case HARDPROFILETRAPENABLE:
        *write_method = write_hardProfileTrapEnable;
        long_ret = hard_profile.trap_enable;
        return (unsigned char *) &long_ret;

    case HARDPROFILECOLDSTARTTRAPACK:
        *write_method = write_hardProfileColdStartTrapAck;
        long_ret = hard_profile.ColdStartTrapAck;
        return (unsigned char *) &long_ret;

    case HARDPROFILECOLDSTARTTRAPFREQUENCY:
        *write_method = write_hardProfileColdStartTrapFrequency;
        long_ret = hard_profile.ColdStartTrapFrequency;
        return (unsigned char *) &long_ret;

    case HARDPROFILECFGCHECKSUM:

        hard_profile.checksum = 1L;
        long_ret = hard_profile.checksum;
        return (unsigned char *) &long_ret;


    default:
      ERROR_MSG("");
  }
  return NULL;
}





int
write_hardProfileTime(int      action,
            u_char   *var_val,
            u_char   var_val_type,
            size_t   var_val_len,
            u_char   *statP,
            oid      *name,
            size_t   name_len)
{
  static unsigned char string[SPRINT_MAX_LEN];

  /* Setting this variable not implemented.  Just a place-holder */

  switch ( action ) {
        case RESERVE1:
          if (var_val_type != ASN_OCTET_STR){
              fprintf(stderr, "write to hardProfileTime not ASN_OCTET_STR\n");
              return SNMP_ERR_WRONGTYPE;
          }
          if (var_val_len > sizeof(string)){
              fprintf(stderr, "write to hardProfileTime: bad length\n");
              return SNMP_ERR_WRONGLENGTH;
          }
          break;

        case RESERVE2:
          break;

        case FREE:
          break;

        case ACTION:
          break;

        case UNDO:
          break;

        case COMMIT:
          break;
  }
  return SNMP_ERR_NOERROR;
}




int
write_hardProfileDate(int      action,
            u_char   *var_val,
            u_char   var_val_type,
            size_t   var_val_len,
            u_char   *statP,
            oid      *name,
            size_t   name_len)
{
  static unsigned char string[SPRINT_MAX_LEN];

  /* Setting this variable not implemented.  Just a place-holder */
  switch ( action ) {
        case RESERVE1:
          if (var_val_type != ASN_OCTET_STR){
              fprintf(stderr, "write to hardProfileDate not ASN_OCTET_STR\n");
              return SNMP_ERR_WRONGTYPE;
          }
          if (var_val_len > sizeof(string)){
              fprintf(stderr,"write to hardProfileDate: bad length\n");
              return SNMP_ERR_WRONGLENGTH;
          }
          break;

        case RESERVE2:
          break;

        case FREE:
          break;

        case ACTION:
          break;

        case UNDO:
          break;

        case COMMIT:
          break;
  }
  return SNMP_ERR_NOERROR;
}




int
write_hardProfileTrapEnable(int      action,
            u_char   *var_val,
            u_char   var_val_type,
            size_t   var_val_len,
            u_char   *statP,
            oid      *name,
            size_t   name_len)
{
  static long *long_ret;


  switch ( action ) {
        case RESERVE1:
            if (var_val_type != ASN_INTEGER){
                fprintf(stderr, "write to hardProfileTrapEnable not ASN_INTEGER\n");
                return SNMP_ERR_WRONGTYPE;
            }
            if (var_val_len > sizeof(long_ret)){
                fprintf(stderr,"write to hardProfileTrapEnable: bad length\n");
                return SNMP_ERR_WRONGLENGTH;
            }
            break;


        case RESERVE2:
            break;


        case FREE:
            break;


        case ACTION:
            break;


        case UNDO:
            break;


        case COMMIT:
            break;
  }
  return SNMP_ERR_NOERROR;
}




int
write_hardProfileColdStartTrapAck(int      action,
            u_char   *var_val,
            u_char   var_val_type,
            size_t   var_val_len,
            u_char   *statP,
            oid      *name,
            size_t   name_len)
{
  static long *long_ret;


  switch ( action ) {
        case RESERVE1:
          if (var_val_type != ASN_INTEGER){
              fprintf(stderr, "write to hardProfileColdStartTrapAck not ASN_INTEGER\n");
              return SNMP_ERR_WRONGTYPE;
          }
          if (var_val_len > sizeof(long_ret)){
              fprintf(stderr,"write to hardProfileColdStartTrapAck: bad length\n");
              return SNMP_ERR_WRONGLENGTH;
          }
          break;

        case RESERVE2:
          break;

        case FREE:
          break;

        case ACTION:
          break;

        case UNDO:
          break;

        case COMMIT:
          break;
  }
  return SNMP_ERR_NOERROR;
}




int
write_hardProfileColdStartTrapFrequency(int      action,
            u_char   *var_val,
            u_char   var_val_type,
            size_t   var_val_len,
            u_char   *statP,
            oid      *name,
            size_t   name_len)
{
  static long *long_ret;


  switch ( action ) {
        case RESERVE1:
            if (var_val_type != ASN_INTEGER){
                fprintf(stderr, "write to hardProfileColdStartTrapFrequency not ASN_INTEGER\n");
                return SNMP_ERR_WRONGTYPE;
            }
            if (var_val_len > sizeof(long_ret)){
                fprintf(stderr,"write to hardProfileColdStartTrapFrequency: bad length\n");
                return SNMP_ERR_WRONGLENGTH;
            }
            break;

        case RESERVE2:
            break;

        case FREE:
            break;

        case ACTION:
            break;

        case UNDO:
            break;

        case COMMIT:
            break;
  }
  return SNMP_ERR_NOERROR;
}

