/* This file was generated by mib2c and is intended for use as a mib module
   for the ucd-snmp snmpd agent. */


#ifdef IN_UCD_SNMP_SOURCE
/* If we're compiling this file inside the ucd-snmp source tree */


/* This should always be included first before anything else */
#include <config.h>


/* minimal include directives */
#include "mibincl.h"
#include "util_funcs.h"


#else /* !IN_UCD_SNMP_SOURCE */


#include <ucd-snmp/ucd-snmp-config.h>
#include <ucd-snmp/ucd-snmp-includes.h>
#include <ucd-snmp/ucd-snmp-agent-includes.h>


#endif /* !IN_UCD_SNMP_SOURCE */


#include "polltable.h"
#include "x42pp/x42pp_status_structs.h"
#include "libcom/stats.h"

struct x42pp_status stats;
static int first_time = 1;

struct packed_status
{
    unsigned char drop;
    unsigned char status;
};

static unsigned long last_uptime = 0;

static char *ascii_drop[] = { /* 157 possible drops */
    /* Normal addresses (0-29) */
    "@", "A", "B", "C", "D", "E", "F", "G", "H",  "I",
    "J", "K", "L", "M", "N", "O", "P", "Q", "R",  "S",
    "T", "U", "V", "W", "X", "Y", "Z", "[", "\\", "]",
    /* Extended addresses - % range (30-61) */
    "%@", "%A", "%B", "%C", "%D", "%E", "%F", "%G", "%H",  "%I",
    "%J", "%K", "%L", "%M", "%N", "%O", "%P", "%Q", "%R",  "%S",
    "%T", "%U", "%V", "%W", "%X", "%Y", "%Z", "%[", "%\\", "%]", "%>", "%?",
    /* Extended addresses - # range (62-93) */
    "#@", "#A", "#B", "#C", "#D", "#E", "#F", "#G", "#H",  "#I",
    "#J", "#K", "#L", "#M", "#N", "#O", "#P", "#Q", "#R",  "#S",
    "#T", "#U", "#V", "#W", "#X", "#Y", "#Z", "#[", "#\\", "#]", "#>", "#?",
    /* Extended addresses - $ range (94-125) */
    "$@", "$A", "$B", "$C", "$D", "$E", "$F", "$G", "$H",  "$I",
    "$J", "$K", "$L", "$M", "$N", "$O", "$P", "$Q", "$R",  "$S",
    "$T", "$U", "$V", "$W", "$X", "$Y", "$Z", "$[", "$\\", "$]", "$>", "$?",
    /* Extended addresses - ! range (126-156) */
    "!@", "!A", "!B", "!C", "!D", "!E", "!F", "!G", "!H",  "!I",
    "!J", "!K", "!L", "!M", "!N", "!O", "!P", "!Q", "!R",  "!S",
    "!T", "!U", "!V", "!W", "!X", "!Y", "!Z", "![", "!\\", "!]", "!>"
};

/*
 * polltable_variables_oid:
 *   this is the top level oid that we want to register under.  This
 *   is essentially a prefix, with the suffix appearing in the
 *   variable below.
 */


oid polltable_variables_oid[] = { 1,3,6,1,4,1,638,2,2,9,1 };


/*
 * variable2 polltable_variables:
 *   this variable defines function callbacks and type return information
 *   for the polltable mib section
 */


struct variable2 polltable_variables[] = {
/*  magic number        , variable type , ro/rw , callback fn  , L, oidsuffix */
#define   ESPADPOLLINDEX        3
  { ESPADPOLLINDEX      , ASN_INTEGER   , RONLY , var_esPadPollTable, 2, { 1,1 } },
#define   ESPADPOLLDROPADDRESS  4
  { ESPADPOLLDROPADDRESS, ASN_INTEGER   , RONLY , var_esPadPollTable, 2, { 1,2 } },
#define   ESPADPOLLDROPALIAS    5
  { ESPADPOLLDROPALIAS  , ASN_OCTET_STR , RONLY , var_esPadPollTable, 2, { 1,3 } },
#define   ESPADPOLLSTATUS       6
  { ESPADPOLLSTATUS     , ASN_INTEGER   , RONLY , var_esPadPollTable, 2, { 1,4 } },

};
/*    (L = length of the oidsuffix) */


/*
 * init_polltable():
 *   Initialization routine.  This is called when the agent starts up.
 *   At a minimum, registration of your variables should take place here.
 */
void init_polltable(void) {
    int i;

    memset(&stats, 0, sizeof(stats));

    /* register ourselves with the agent to handle our mib tree */
    REGISTER_MIB("polltable", polltable_variables, variable2,
                  polltable_variables_oid);
}


/*
 * var_polltable():
 *   This function is called every time the agent gets a request for
 *   a scalar variable that might be found within your mib section
 *   registered above.  It is up to you to do the right thing and
 *   return the correct value.
 *     You should also correct the value of "var_len" if necessary.
 *
 *   Please see the documentation for more information about writing
 *   module extensions, and check out the examples in the examples
 *   and mibII directories.
 */
unsigned char *
var_polltable(struct variable *vp,
                oid     *name,
                size_t  *length,
                int     exact,
                size_t  *var_len,
                WriteMethod **write_method)
{


  /* variables we may use later */
  static long long_ret;
  static u_long ulong_ret;
  static unsigned char string[SPRINT_MAX_LEN];
  static oid objid[MAX_OID_LEN];
  static struct counter64 c64;


  if (header_generic(vp,name,length,exact,var_len,write_method)
                                  == MATCH_FAILED )
    return NULL;


  /*
   * this is where we do the value assignments for the mib results.
   */
  switch(vp->magic) {



    default:
      ERROR_MSG("");
  }
  return NULL;
}


/*
 * var_esPadPollTable():
 *   Handle this table separately from the scalar value case.
 *   The workings of this are basically the same as for var_polltable above.
 */
unsigned char *
var_esPadPollTable(struct variable *vp,
            oid     *name,
            size_t  *length,
            int     exact,
            size_t  *var_len,
            WriteMethod **write_method)
{


  /* variables we may use later */
  static long long_ret;
  int index;
  int status;
  int drop;
  struct packed_status my_stats[MAX_DROPS];
  int i, j;
  unsigned long current_uptime;
  long pid;

  /*
   * This assumes that the table is a 'simple' table.
   *    See the implementation documentation for the meaning of this.
   *    You will need to provide the correct value for the TABLE_SIZE parameter
   *
   * If this table does not meet the requirements for a simple table,
   *    you will need to provide the replacement code yourself.
   *    Mib2c is not smart enough to write this for you.
   *    Again, see the implementation documentation for what is required.
   */
  if (header_simple_table(vp,name,length,exact,var_len,write_method, MAX_DROPS)
                                                == MATCH_FAILED )
    return NULL;


  current_uptime = netsnmp_get_agent_uptime();


  /* Only call stats function if its more than 20 seconds since last call. */
  /* Do this because call takes 3-4 seconds and don't want to do it every  */
  /* time if we're doing a walk.                                           */
  if (( (first_time) || ((current_uptime - last_uptime) > 2000) )) {
    /*printf("Calling stats_get function\n");*/
    /* if polling process isn't running */
    if ((pid = get_pid("x42pp")) == 0)
        return NULL;

    if (stats_get("x42pp", &stats, sizeof (stats)) == 0)
        return NULL;
     last_uptime = current_uptime;
     first_time = 0;
  }


  /* go through list of drops and make a packed list of configured drops */
  for (i = 0, j = 0; i < MAX_DROPS; i++) {
      if (stats.drop_status[i] != NOT_CFG) {
          my_stats[j].drop = i;
          my_stats[j].status = stats.drop_status[i];
          j++;
      }
  }

  /* no configured drops */
  if (j == 0)
     return NULL;;

  index = name[*length-1];

  /* if no more configured drops on the list */
  if (index > j)
     return NULL;;

  status = (int)my_stats[index-1].status;
  drop = (int)my_stats[index-1].drop;

  if (status == NOT_CFG)
    return NULL;

  /*
   * this is where we do the value assignments for the mib results.
   */
  switch(vp->magic) {


    case ESPADPOLLINDEX:

        long_ret = index;
        return (unsigned char *) &long_ret;

    case ESPADPOLLDROPADDRESS:

        long_ret = drop;
        return (unsigned char *) &long_ret;

    case ESPADPOLLDROPALIAS:

        return (unsigned char *) ascii_drop[drop];

    case ESPADPOLLSTATUS:

        long_ret = status;
        return (unsigned char *) &long_ret;


    default:
      ERROR_MSG("");
  }
  return NULL;
}
