#ifndef __MESC_CFG_H__
#define __MESC_CFG_H__

/* ===[ $RCSfile: mesc_cfg.h,v $ ]========================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2003-2005 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: mesc_cfg.h,v 1.8 2005/03/24 16:43:40 cmayncvs Exp $"
 *
 *  \brief Contains the MESC config file typedef & defaults.
 */
/* ======================================================================= */
/* ======= */
/* Defines */
/* ======= */
/** MESC configuration parameter record name. */
#define mesc_cfg_record         "MESC"
/** The number of MESC configuration parameters */
#define MESC_CFG_COUNT          16

/** Identifies method of constructing Terminal Name similar to how ESPAD is
 * assigned its Terminal ID under the "Unusual Terminal ID Requirements"
 * section 3.3 of the aforementioned document. */
#define MESC_CFG_ID_PAD_STYLE   0
/** Identifies method of constructing Terminal Name as using the following
 * method described in the "Terminal Nomenclature and Terminal ID Assignment"
 * white paper authored by Tom Oram:  Add the Terminal IDN (9-digits total, but
 * reserving 3 digits for "drop number") to the Obfuscating number, 042396879,
 * then prepend the Site ID and re-format the 12 digit number into
 * sssn-nnnn-nnnn- and finally feed the entire thing into the check digit
 * algorithm to compute the 2 check digits, which get appended to the whole
 * thing (sssn-nnnn-nnnn-cc). */
#define MESC_CFG_ID_OBFUSCATE   1
/** Identifies method of contructing Terminal Name as using raw Terminal ID,
 * A 2-digit hex "drop number" will be appended for each drop, and the check
 * digits will also be automatically computed and appended as well. */
#define MESC_CFG_ID_RAW         2


/*==========*/
/* Typedefs */
/*==========*/
/** \brief Typedef for MESC configuration parameters. */
typedef struct {
    u_int16_t dbg_level;        /**< 1) Debug level (debug.h has values) */
    u_int16_t id_method;        /**< 2) Method of terminal name identification:
                                        1) Use raw Terminal ID field
                                        2) Append check digits to terminal ID
                                        3) Create from:
                                            a) Terminal IDN: 9-digits
                                            b) Obfuscating #: 042396879
                                            c) 3-digit Site ID: Range:001-499,
                                            ... append drop & check digits. */
    char terminal_id[50];       /**< 3) Terminal ID: Raw method */
    u_int32_t terminal_idn;     /**< 4) Terminal IDN: Obfuscate method */
    u_int16_t site_id;          /**< 5) Site ID (1st 3 digits of client ID) */
    u_int16_t hw_type_id;       /**< 6) Hardware Type ID (2-digits: 4-5) */
    u_int16_t unit_id;          /**< 7) Unit ID (5 client ID digits: 6-10) */
    char rom_id[5];             /**< 8) ROM ID (ESPAD only) */
    char host1[50];             /**< 9) Primary host address */
    char host2[50];             /**< 10) Secondary host address */
    u_int16_t base_port;        /**< 11) UDP Base port */
    u_int32_t tmo_cnt;          /**< 12) Timeout count to rotate hosts (0=no) */
    u_int32_t min_rsp_tmo;      /**< 13) Minimum response timeout (secs) */
    u_int32_t max_rsp_tmo;      /**< 14) Maximum response timeout (secs) */
    u_int16_t keepalive_tmo;    /**< 15) Keep-alive timeout (seconds) */
    u_int16_t drop0_is_special; /**< 16) Flag for appending drop 0 to name */

    /* IMPORTANT - When adding parameters, be sure to update MESC_CFG_COUNT! */

} mesc_cfg_t;

/** Holds the default MESC configuration parameters. */
static const mesc_cfg_t mesc_cfg_defaults = {
    .dbg_level = DBG_INFO3,      /**< 1) default mesc debug level */
    .id_method = MESC_CFG_ID_PAD_STYLE,/**< 2) Use pad-style terminal ID */
    .terminal_id = "T001",      /**< 3) Terminal ID (same as ESCP & ESC) */
    .terminal_idn = 0,          /**< 4) Terminal IDN (obfuscate method) */
    .site_id = 500,             /**< 5) Site ID (1st 3 digits of client ID) */
    .hw_type_id = 2,            /**< 6) Hardware Type ID (2-digits: 4-5) */
    .unit_id = 0,               /**< 7) Unit ID (5 client ID digits: 6-10) */
    .rom_id = "A7GS",           /**< 8) ROM ID (ESPAD only) */
    .host1 = "XXESC01.gtk.gtech.com",   /**< 9) Primary host address */
    .host2 = "",                /**< 10) Secondary host address */
    .base_port = 50000,         /**< 11) UDP Base port  MESC_CFG_BASE_PORT */
    .tmo_cnt = 3,               /**< 12) Timeout count to rotate hosts (0=no) */
    .min_rsp_tmo = 3,           /**< 13) Minimum response timeout (seconds) */
    .max_rsp_tmo = 30,          /**< 14) Maximum response timeout (seconds) */
    .keepalive_tmo = 60,        /**< 15) Keep-alive timeout (seconds) */
    .drop0_is_special = 0       /**< 16) Do append drop 0 to client name */

    /* IMPORTANT - When adding parameters, be sure to update MESC_CFG_COUNT! */

};


#endif /* __MESC_CFG_H__ */


/*
 * End of "$Id: mesc_cfg.h,v 1.8 2005/03/24 16:43:40 cmayncvs Exp $".
 */


