#ifndef __ESCP_H__
#define __ESCP_H__

/* ===[ $RCSfile: escp.h,v $ ]============================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2003-2005 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: escp.h,v 1.3 2005/01/31 20:48:25 cmayncvs Exp $"
 *
 *  \brief Contains ESCP defines.
 */
/* ======================================================================= */

#define ESCP_UDP_PORT                   0xD099  /**< The ESCP server port */
#define ESCP_PROTOCOL_ID                0x1B    /**< Protocol Identifier */
#define ESCP_PACKET_TYPE_MASK           0x30    /**< Packet type mask */
#define ESCP_PACKET_TYPE_UNSO           0x00    /**< An unsolicited packet  */
#define ESCP_PACKET_TYPE_REQUEST        0x10    /**< A request packet  */
#define ESCP_PACKET_TYPE_RESPONSE       0x20    /**< A response packet  */
/** Isolates just the packet type from the type */
#define ESCP_PACKET_TYPE(type)          ((type) & ESCP_PACKET_TYPE_MASK)

#define ESCP_HEADER_FORMAT_MASK         0x02    /**< Header format mask */
#define ESCP_HEADER_FORMAT_STANDARD     0x00    /**< Standard header */
#define ESCP_HEADER_FORMAT_OPTIONAL     0x02    /**< Optional header */
/** Isolates just the header format from the type */
#define ESCP_HEADER_FORMAT(type)        ((type) & ESCP_HEADER_FORMAT_MASK)

#define ESCP_MESSAGE_TYPE_MASK          0x01    /**< Message type mask */
#define ESCP_MESSAGE_TYPE_PROTO         0x00    /**< Protocol message type */
#define ESCP_MESSAGE_TYPE_APP           0x01    /**< Application message type */
/** Isolates just the message type from the type */
#define ESCP_MESSAGE_TYPE(type)         ((type) & ESCP_MESSAGE_TYPE_MASK)

#define ESCP_STATS_OPTS_MASK            0x07    /**< Statistics options mask */
#define ESCP_STATS_OPTS_CLIENT_NAME_BIT 0x01    /**< Client name bit */
#define ESCP_STATS_OPTS_RQSTS_RESPS_BIT 0x02    /**< Rqsts/Resps bit */
#define ESCP_STATS_OPTS_UNSOS_BIT       0x04    /**< Unsolicited bit */

#define ESCP_CNTRL_OPTS_MASK            0x0F    /**< Control options mask */
#define ESCP_CNTRL_OPTS_STATS_MASK_BIT  0x01    /**< Statistics mask bit */
#define ESCP_CNTRL_OPTS_DISABLE_BIT     0x02    /**< Disable w/timeout bit */
#define ESCP_CNTRL_OPTS_CLEAR_STATS_BIT 0x04    /**< Clear statistics bit */
#define ESCP_CNTRL_OPTS_KEEP_ALIVE_BIT  0x08    /**< Keep-alive timeout bit */

#define ESCP_SEQ_NO_UNKNOWN             0       /**< An unknown sequence # */
#define ESCP_SAP_UNKNOWN                0       /**< An unknown SAP */
#define ESCP_NO_PREV_RESP_TIME          0xFFFF  /**< No prev response time */
#define ESCP_ENABLE                     0       /**< enable */
#define ESCP_DISABLE_FOREVER            0xFFFF  /**< disable 'forever' */
#define ESCP_DISABLE_KEEPALIVE          0xFFFF  /**< keepalive disable */

/** Configuration Required message type */
#define ESCP_CONFIG_REQUIRED            0xC0
/** Configuration Step 1 Request/Response message type */
#define ESCP_CONFIG_STEP_1              0xC1
/** Configuration Step 2 Request/Response message type */
#define ESCP_CONFIG_STEP_2              0xC2
/** Keep-alive message type */
#define ESCP_KEEP_ALIVE                 0xC3

/** Struct for an ESCP request header */
struct escp_rqst_hdr_adt {
    u_int8_t pid;           /**< Protocol ID: Always ESCP_PROTOCOL_ID */
    u_int8_t type;          /**< Packet type: type + opt + msg */
    u_int8_t sap;           /**< Service Access Point */
    u_int8_t seq_no;        /**< Sequence number */
    u_int16_t prev_resp_tm; /**< Previous response time (milliseconds) */

    /* possible stats options & options precede data */

    u_int8_t data[0];       /**< Start of data */
} __attribute__((packed));

/** Typedef for an ESCP request header */
typedef struct escp_rqst_hdr_adt escp_rqst_hdr_t;

/** Struct for an ESCP response header */
struct escp_resp_hdr_adt {
    u_int8_t pid;           /**< Protocol ID: Always ESCP_PROTOCOL_ID */
    u_int8_t type;          /**< Packet type: type + opt + msg */
    u_int8_t sap;           /**< Service Access Point */
    u_int8_t seq_no;        /**< Sequence number */

    /* possible control options & options data precede data */

    u_int8_t data[0];       /**< Start of data */
} __attribute__((packed));

/** Typedef for an ESCP response header */
typedef struct escp_resp_hdr_adt escp_resp_hdr_t;

/** Struct for an ESCP unsolicited header */
struct escp_unso_hdr_adt {
    u_int8_t pid;           /**< Protocol ID: Always ESCP_PROTOCOL_ID */
    u_int8_t type;          /**< Packet type: type + opt + msg */
    u_int8_t sap;           /**< Service Access Point */
    u_int8_t tn_len;        /**< Target name length */

    /* variable length target name, as well as possible control options &
     * options data precede data */

    u_int8_t data[0];       /**< Start of data (target name) */
} __attribute__((packed));

/** Typedef for an ESCP unsolicited header */
typedef struct escp_unso_hdr_adt escp_unso_hdr_t;

/** Struct for an ESCP config required message */
struct escp_cfg_rqrd_msg_adt {
    u_int8_t msg_id;        /**< Message ID:  Always ESCP_CONFIG_REQUIRED */
} __attribute__((packed));

/** Typedef for an ESCP config required message */
typedef struct escp_cfg_rqrd_msg_adt escp_cfg_rqrd_msg_t;

/** Struct for an ESCP config step 1 request message */
struct escp_cfg_step1_rqst_msg_adt {
    u_int8_t msg_id;        /**< Message ID:  Always ESCP_CONFIG_STEP_1 */
    u_int8_t cn_len;        /**< Client name length */

    /* variable length client name, device class length and variable length
     * device class, and hardware ID length and variable length hardware ID
     * follow */
    u_int8_t data[0];       /**< Start of data */
} __attribute__((packed));

/** Typedef for an ESCP config step 1 request message */
typedef struct escp_cfg_step1_rqst_msg_adt escp_cfg_step1_rqst_msg_t;

/** Struct for an ESCP config step 1 response message */
struct escp_cfg_step1_resp_msg_adt {
    u_int8_t msg_id;        /**< Message ID:  Always ESCP_CONFIG_STEP_1 */
    u_int8_t next_seq_no;   /**< Next sequence number */
    u_int8_t acn_len;       /**< Application Configuration Name length */

    /* variable length application configuration name, comm id length and
     * comm id, comm config length and comm config, and broadcast info length
     * and broadcast info follow */
    u_int8_t data[0];       /**< Start of data */
} __attribute__((packed));

/** Typedef for an ESCP config step 1 response message */
typedef struct escp_cfg_step1_resp_msg_adt escp_cfg_step1_resp_msg_t;

/** Struct for an ESCP config step 2 request message */
struct escp_cfg_step2_rqst_msg_adt {
    u_int8_t msg_id;        /**< Message ID:  Always ESCP_CONFIG_STEP_2 */
    u_int8_t ua_len;        /**< Unicast Address length */

    /* variable length unicast address, broadcast address length and broadcast
     * address follow */
    u_int8_t data[0];       /**< Start of data */
} __attribute__((packed));

/** Typedef for an ESCP config step 2 request message */
typedef struct escp_cfg_step2_rqst_msg_adt escp_cfg_step2_rqst_msg_t;

/** Struct for an ESCP config step 2 response message */
struct escp_cfg_step2_resp_msg_adt {
    u_int8_t msg_id;        /**< Message ID:  Always ESCP_CONFIG_STEP_2 */
} __attribute__((packed));

/** Typedef for an ESCP config step 2 response message */
typedef struct escp_cfg_step2_resp_msg_adt escp_cfg_step2_resp_msg_t;

/** Struct for an ESCP keep-alive message */
struct escp_keepalive_msg_adt {
    u_int8_t msg_id;        /**< Message ID:  Always ESCP_KEEP_ALIVE */
} __attribute__((packed));

/** Typedef for an ESCP keep-alive message */
typedef struct escp_keepalive_msg_adt escp_keepalive_msg_t;

#endif /* __ESCP_H__ */


/*
 * End of "$Id: escp.h,v 1.3 2005/01/31 20:48:25 cmayncvs Exp $".
 */


