#ifndef __MESC_ART_H__
#define __MESC_ART_H__

/* ===[ $RCSfile: mesc_art.h,v $ ]========================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2003 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  $Id: mesc_art.h,v 1.1.1.1 2003/12/02 15:53:30 sbobcvs Exp $
 *
 *  \brief Contains the MESC ART API.
 */
/* ======================================================================= */

/* === */
/* API */
/* === */
void mesc_art_init(void);
void mesc_art_mark_resp_tmo(u_int8_t drop);
void mesc_art_update(u_int8_t drop, u_int32_t rt);
int16_t mesc_art_get_tmo(u_int8_t drop);
int mesc_art_get_noise(u_int8_t drop);
void mesc_art_set_min_rsp_tmo(u_int8_t drop, u_int32_t min);
void mesc_art_set_max_rsp_tmo(u_int8_t drop, u_int32_t max);
u_int32_t mesc_art_get_min_rsp_tmo(u_int8_t drop);
u_int32_t mesc_art_get_max_rsp_tmo(u_int8_t drop);

#endif /* __MESC_ART_H__ */


/*
 * End of $Id: mesc_art.h,v 1.1.1.1 2003/12/02 15:53:30 sbobcvs Exp $
 */


