#ifndef __MESC_RT_CFG_H__
#define __MESC_RT_CFG_H__

/* ===[ $RCSfile: mesc_cfg.h,v $ ]========================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2003-2005 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: mesc_cfg.h,v 1.8 2005/03/11 20:36:53 cmayncvs Exp $"
 *
 *  \brief Contains the MESC Run-Time Configuration API.
 */
/* ======================================================================= */

/* ======= */
/* Defines */
/* ======= */
/** Base port: Drop 0 will use this, drop 1 will use this - 1, ... */
#define MESC_CFG_BASE_PORT          50000   /* 0xC350 */
/** Maximum number of drops the pad will support (of absolute max of 157) */
#define MESC_CFG_MAX_DROPS          157
/** Min response time changed */
#define MESC_CFG_T0                 0x01
/** Max response time changed */
#define MESC_CFG_T1                 0x02
/** Timeout count changed */
#define MESC_CFG_TC                 0x04

/** The Obfuscating Number */
#define MESC_CFG_OBFUSCATE_NUM  42396879

/* ======== */
/* Typedefs */
/* ======== */
/** All the ESC parameters changeable via Config Step 1 Response */
typedef struct {
    u_int32_t t0;       /**< minimum response time */
    u_int32_t t1;       /**< maximum response time */
    u_int32_t tc;       /**< timeout count */
    u_int8_t flags;     /**< specifies which have changed */
} cfg_t;

/* === */
/* API */
/* === */
void mesc_cfg_init(void);

u_int8_t mesc_cfg_get_dbg_level(void);
char *mesc_cfg_level2str(int level);
u_int16_t mesc_cfg_get_site_id(void);
u_int16_t mesc_cfg_get_hw_type_id(void);
char *mesc_cfg_hwid2str(u_int16_t id);
u_int16_t mesc_cfg_get_unit_id(void);
char *mesc_cfg_get_rom_id(void);
char *mesc_cfg_get_pad_rom_id(void);
char *mesc_cfg_get_host1(void);
char *mesc_cfg_get_host2(void);
u_int32_t mesc_cfg_get_tmo_cnt(void);
u_int32_t mesc_cfg_get_min_rsp_tmo(void);
u_int32_t mesc_cfg_get_max_rsp_tmo(void);
u_int32_t mesc_cfg_get_keepalive_tmo(void);
u_int16_t mesc_cfg_get_base_port(void);

void mesc_cfg_set_secure(u_int16_t flag);
u_int16_t mesc_cfg_is_secure(void);
u_int16_t mesc_cfg_get_port(u_int8_t drop);
u_int16_t mesc_cfg_get_max_drops(void);
void mesc_cfg_get_client_name(u_int8_t drop, char *name);
void mesc_cfg_get_hw_id(u_int8_t drop, char *hw_id);
char *mesc_cfg_get_ip_addr(void);
void mesc_cfg_process(const char *data, cfg_t *cfg);
char *mesc_cfg_drop2ascii(u_int8_t drop);
char *mesc_cfg_siteid2str(u_int16_t id);
char *mesc_cfg_get_terminal_type(char *id);
#endif /* __MESC_RT_CFG_H__ */


/*
 * End of "$Id: mesc_cfg.h,v 1.8 2005/03/11 20:36:53 cmayncvs Exp $".
 */


