#ifndef __MESC_DBG_H__
#define __MESC_DBG_H__

/* ===[ $RCSfile: mesc_dbg.h,v $ ]========================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2003-2005 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: mesc_dbg.h,v 1.2 2005/02/17 20:17:41 cmayncvs Exp $"
 *
 *  \brief Contains the MESC debug API.
 */
/* ======================================================================= */

extern u_int8_t mesc_dbg_level;

/** mesc module debug level variable name */
#define MODULE_DEBUG_LEVEL  mesc_dbg_level
/** mesc's module name */
#define MODULE_NAME         "MESC"

#include "debug.h"

/* === */
/* API */
/* === */
void mesc_dbg_init(int level);
void mesc_dbg_set_level(u_int8_t level);
u_int8_t mesc_dbg_get_level(void);
char *mesc_dbg_level2str(u_int8_t level);
u_int32_t mesc_dbg_time(void);
void mesc_dbg_time_stamp(void);
void mesc_dbg_print_buf(buf_t b);

#endif /* __MESC_DBG__H__ */


/*
 * End of "$Id: mesc_dbg.h,v 1.2 2005/02/17 20:17:41 cmayncvs Exp $".
 */


