#ifndef __MESC_FSM_H__
#define __MESC_FSM_H__

/* ===[ $RCSfile: mesc_fsm.h,v $ ]========================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2003-2005 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  $Id: mesc_fsm.h,v 1.5 2005/03/22 20:23:25 cmayncvs Exp $
 *
 *  \brief Contains the MESC Finite State Machine API.
 */
/* ======================================================================= */

/* === */
/* API */
/* === */
void mesc_fsm_init(void);
void mesc_fsm_print(FILE *f, u_int8_t drop);

void mesc_fsm_process_tx_req(u_int8_t drop, char *data, int data_len, u_int8_t sap);
void mesc_fsm_process_resp_tmo(u_int8_t drop);
void mesc_fsm_process_keepalive_tmo(u_int8_t drop);
void mesc_fsm_process_disable_tmo(u_int8_t drop);
void mesc_fsm_process_tx_data_ind(u_int8_t drop);
buf_t mesc_fsm_process_multicast(buf_t b);
buf_t mesc_fsm_process_unicast(u_int8_t drop, buf_t b);
void mesc_fsm_process_x42_drop_status(u_int8_t drop, const char *status);
void mesc_fsm_process_comm_status(int status);

#endif /* __MESC_FSM_H__ */


/*
 * End of $Id: mesc_fsm.h,v 1.5 2005/03/22 20:23:25 cmayncvs Exp $
 */


