#ifndef __MESC_IMP_H__
#define __MESC_IMP_H__

/* ===[ $RCSfile: mesc_imp.h,v $ ]========================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2003-2005 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: mesc_imp.h,v 1.4 2005/01/31 20:48:25 cmayncvs Exp $"
 *
 *  \brief Contains the MESC Inter-module Protocol (IMP) API .
 */
/* ======================================================================= */

/* =================== */
/* Function Prototypes */
/* =================== */
/* Misc. */
void mesc_imp_init(const char *local_q, const char *upper_q,
                   const char *lower_q, const char *pad_q);

/* Outgoing IMP messages */
void mesc_imp_send_rsp(u_int8_t drop, u_int8_t *data, int length, u_int8_t sap);
void mesc_imp_send_unso(u_int8_t drop, u_int8_t *data, int length, int dest);
void mesc_imp_send_rsp_tmo(u_int8_t drop, u_int8_t sap);
void mesc_imp_send_status(u_int8_t drop, u_int8_t status);
void mesc_imp_send_status_msg(u_int8_t drop, char *msg);
void mesc_imp_send_multicast_join_msg(char *mcast_addr, u_int16_t port);
void mesc_imp_send_msecp_msg(u_int8_t drop, buf_t raw_rqst);

#endif /* __MESC_IMP_H__ */


/*
 * End of "$Id: mesc_imp.h,v 1.4 2005/01/31 20:48:25 cmayncvs Exp $".
 */


