#ifndef __MESC_STAT_H__
#define __MESC_STAT_H__

/* ===[ $RCSfile: mesc_stat.h,v $ ]=======================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2003-2005 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: mesc_stat.h,v 1.2 2005/02/04 16:06:12 cmayncvs Exp $"
 *
 *  \brief Contains the Multi-drop ES-Connect (MESC) Statistics handling API.
 */
/* ======================================================================= */

/* === */
/* API */
/* === */
void mesc_stat_init(void);

/* ESCP-related statistics */
u_int8_t mesc_stat_get_mask(u_int8_t drop);
void mesc_stat_set_mask(u_int8_t drop, u_int8_t mask);
char *mesc_stat_get_client_name(u_int8_t drop);
u_int32_t mesc_stat_get_escp_rqsts(u_int8_t drop);
u_int32_t mesc_stat_get_escp_resps(u_int8_t drop);
u_int32_t mesc_stat_get_escp_unsos(u_int8_t drop);
buf_t mesc_stat_get_escp_stats(u_int8_t drop);
void mesc_stat_clear_escp_stats(u_int8_t drop);
void mesc_stat_update_escp_rqsts(u_int8_t drop);
void mesc_stat_update_escp_resps(u_int8_t drop);
void mesc_stat_update_escp_unsos(u_int8_t drop, int dest);

/* IMP-related statistics */
void mesc_stat_update_imp_rqsts(u_int8_t drop);
void mesc_stat_update_imp_resps(u_int8_t drop);
void mesc_stat_update_imp_unsos(u_int8_t drop, int dest);
void mesc_stat_update_imp_resp_tmos(u_int8_t drop);
void mesc_stat_update_imp_x42_drop_status(u_int8_t drop);

/* Timer-related statistics (also IMP) */
void mesc_stat_update_resp_tmos(u_int8_t drop);
void mesc_stat_update_keepalive_tmos(u_int8_t drop);
void mesc_stat_update_disable_tmos(u_int8_t drop);

#endif /* __MESC_STAT_H__ */


/*
 * End of "$Id: mesc_stat.h,v 1.2 2005/02/04 16:06:12 cmayncvs Exp $".
 */


