#ifndef __MESC_TMR_H__
#define __MESC_TMR_H__

/* ===[ $RCSfile: mesc_tmr.h,v $ ]========================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2003 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: mesc_tmr.h,v 1.2 2005/01/31 20:48:25 cmayncvs Exp $"
 *
 *  \brief Contains the MESC timer API .
 */
/* ======================================================================= */

/* ======= */
/* Defines */
/* ======= */
#define MESC_TMR_ID         MESC_CFG_BASE_PORT  /**< A unique MESC timer ID */
#define MESC_TMR_RESPONSE   1                   /**< Timer response type */
#define MESC_TMR_KEEPALIVE  2                   /**< Timer keepalive type */
#define MESC_TMR_DISABLE    3                   /**< Timer disable type */
#define MESC_TMR_MAX_TIMER  MESC_TMR_DISABLE    /**< Maximum timer type */

/* === */
/* API */
/* === */
void mesc_tmr_init(void);
void mesc_tmr_start_resp(u_int8_t drop);
void mesc_tmr_start_keepalive(u_int8_t drop, u_int16_t sec);
void mesc_tmr_start_disable(u_int8_t drop, u_int16_t sec);
void mesc_tmr_stop_resp(u_int8_t drop);
void mesc_tmr_stop_keepalive(u_int8_t drop);
void mesc_tmr_stop_disable(u_int8_t drop);

u_int16_t mesc_tmr_get_id(u_int32_t tmr);
u_int8_t mesc_tmr_get_drop(u_int32_t tmr);
u_int8_t mesc_tmr_get_type(u_int32_t tmr);
int mesc_tmr_is_mesc_tmr(u_int32_t tmr);

u_int16_t mesc_tmr_get_prev_resp_time(u_int8_t drop);
void mesc_tmr_reset_prev_resp_time(u_int8_t drop);

void mesc_tmr_mark_end(u_int8_t drop);

#endif /* __MESC_TMR_H__ */


/*
 * End of "$Id: mesc_tmr.h,v 1.2 2005/01/31 20:48:25 cmayncvs Exp $".
 */


