#ifndef __MESC_UDP_H__
#define __MESC_UDP_H__

/* ===[ $RCSfile: mesc_udp.h,v $ ]========================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2003-2005 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: mesc_udp.h,v 1.2 2005/01/31 20:48:25 cmayncvs Exp $"
 *
 *  \brief Contains the MESC UDP API. (Enough acronyms for you?)
 */
/* ======================================================================= */

/* === */
/* API */
/* === */
void mesc_udp_init(void);
void mesc_udp_open(int drop);
void mesc_udp_send(u_int8_t drop, buf_t b);
void mesc_udp_use_next_addr(u_int8_t drop);
void mesc_udp_multicast_join(const char *data, u_int8_t len);
char *mesc_udp_get_multicast_str(void);
void mesc_udp_dns_lookup(u_int8_t drop);
void mesc_udp_print(FILE *f, u_int8_t drop);
#endif /* __MESC_UDP_H__ */


/*
 * End of "$Id: mesc_udp.h,v 1.2 2005/01/31 20:48:25 cmayncvs Exp $".
 */


