#ifndef __MSECP_CFG_H__
#define __MSECP_CFG_H__

/* ===[ $RCSfile: msecp_cfg.h,v $ ]========================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2004 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: msecp_cfg.h,v 1.2 2004/07/13 18:45:42 tmeiccvs Exp $"
 *
 *  \brief Contains the MSECP config file typedef & defaults.
 */
/* ======================================================================= */
/* ======= */
/* Defines */
/* ======= */
/** MSECP configuration parameter record name. */
#define msecp_cfg_record         "MSEC"
/** The number of MSECP configuration parameters */
#define MSECP_CFG_COUNT          9

/*==========*/
/* Typedefs */
/*==========*/
/** \brief Typedef for MSECP configuration parameters. */
typedef struct {
    u_int8_t dbg_level;        /**< 1) Debug level (debug.h has values) */
    char host1[32];            /**< 2) Primary host address */
    char host2[32];            /**< 3) Secondary host address */
    char client_id[32];        /**< 4) Secondary host address */
    u_int16_t udp_base_port;   /**< 5) Client ID */
    u_int8_t session_test;     /**< 6) Secure Session Tests Flag */
    u_int32_t tmo_cnt;         /**< 7) Timeout count to rotate hosts (0=no) */
    u_int32_t min_rsp_tmo;     /**< 8) Minimum response timeout (secs) */
    u_int32_t max_rsp_tmo;     /**< 9) Maximum response timeout (secs) */
    /* IMPORTANT - When adding parameters, be sure to update MSECP_CFG_COUNT! */
} msecp_cfg_t __attribute__ ((packed));

/** Holds the default MSECP configuration parameters. */
static const msecp_cfg_t msecp_cfg_defaults = {
    .dbg_level = DBG_INFO3,     /**< 1) default msecp debug level */
    .host1 = "156.24.197.101",  /**< 2) Primary host address */
    .host2 = "",                /**< 3) Secondary host address */
    .client_id ="",             /**< 4) Client ID */
    .udp_base_port = 51000,     /**< 5) UDP Base Port */
    .session_test = 1,          /**< 6) Secure Session Tests Enabled */
    .tmo_cnt = 3,               /**< 7) Timeout count to rotate hosts (0=no) */
    .min_rsp_tmo = 3,           /**< 8) Minimum response timeout (seconds) */
    .max_rsp_tmo = 60,          /**< 9) Maximum response timeout (seconds) */

    /* IMPORTANT - When adding parameters, be sure to update MSECP_CFG_COUNT! */
};


#endif /* __MSECP_CFG_H__ */

/*
 * End of "$Id: msecp_cfg.h,v 1.2 2004/07/13 18:45:42 tmeiccvs Exp $".
 */
