#ifndef __CRYPTO__
#define __CRYPTO__

#define MAX_VARTEXT_LENGTH  64

int crypt_digest(char *buf, int size, unsigned char **dgst, int *dlen);
int crypt_sign(char *data, unsigned int data_sz, void *pkey, unsigned char **sig, unsigned int *siglen);
int crypt_verify(char *data, unsigned int dlen, void *pkey, unsigned char *sig, int siglen);
int crypt_sym_encrypt_init(struct secure *psec, int alg, unsigned char *key, unsigned char *iv);
int crypt_sym_decrypt_init(struct secure *psec, int alg, unsigned char *key, unsigned char *iv);
int crypt_sym_encrypt(struct secure *psec, unsigned char *buf, int dlen, unsigned char *ebuf);
int crypt_sym_decrypt(struct secure *psec, unsigned char *ebuf, int elen, unsigned char *buf);
int crypt_sess_encrypt(struct secure *psec, unsigned char *buf, int blen, unsigned char *ebuf);
int crypt_sess_decrypt(struct secure *psec, unsigned char *ebuf, int elen, unsigned char *buf);
int crypt_unso_encrypt(struct secure *psec, unsigned char *buf, int len, unsigned char *ebuf);
int crypt_unso_decrypt(struct secure *psec, unsigned char *ebuf, int elen, unsigned char *buf);
int crypt_write_public(RSA *rsa, int fd);
int crypt_read_public(RSA **rsa, int fd);
int crypt_write_private(RSA *rsa, int fd);
int crypt_read_private(RSA **rsa, int fd);
int crypt_asym_decrypt(RSA *rsa, unsigned char *ebuf, int elen, unsigned char *buf);
int crypt_asym_encrypt(RSA *rsa, unsigned char *buf, int blen, unsigned char *ebuf);
unsigned char *crypt_encode_akey(RSA *rsa, unsigned short *len);
RSA *decode_pub_key(unsigned char **pubKey, long key_sz);
int crypt_read_keys(struct secure  *esec);
int crypt_generate_keys(struct secure *psec);
int crypt_write_server_pub_key(struct secure *psec);
int crypt_read_server_pub_key(struct secure *psec);


#endif
