#ifndef __MSECP_ART_H__
#define __MSECP_ART_H__

/* ===[ $RCSfile: msecp_art.h,v $ ]========================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2004 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  $Id: msecp_art.h,v 1.1 2004/07/12 18:03:47 tmeiccvs Exp $
 *
 *  \brief Contains the MSECP ART API.
 */
/* ======================================================================= */

/* === */
/* API */
/* === */
void msecp_art_init(void);
void msecp_art_mark_resp_tmo(u_int8_t drop);
void msecp_art_update(u_int8_t drop, u_int32_t rt);
int16_t msecp_art_get_tmo(u_int8_t drop);
int msecp_art_get_noise(u_int8_t drop);
void msecp_art_set_min_rsp_tmo(u_int8_t drop, u_int32_t min);
void msecp_art_set_max_rsp_tmo(u_int8_t drop, u_int32_t max);
u_int32_t msecp_art_get_min_rsp_tmo(u_int8_t drop);
u_int32_t msecp_art_get_max_rsp_tmo(u_int8_t drop);

#endif /* __MSECP_ART_H__ */


/*
 * End of $Id: msecp_art.h,v 1.1 2004/07/12 18:03:47 tmeiccvs Exp $
 */
