#ifndef __MSECP_RT_CFG_H__
#define __MSECP_RT_CFG_H__

/* ===[ $RCSfile: msecp_cfg.h,v $ ]========================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2004 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: msecp_cfg.h,v 1.1 2004/07/12 18:03:47 tmeiccvs Exp $"
 *
 *  \brief Contains the MSECP Run-Time Configuration API.
 */
/* ======================================================================= */

/* ======= */
/* Defines */
/* ======= */

/** Base port: Drop 0 will use this, drop 1 will use this - 1, ... */
#define MSECP_CFG_BASE_PORT          0xFACE
/** Maximum number of drops the pad will support (of absolute max of 157) */
#define MSECP_CFG_MAX_DROPS          157

/** MSECP prefix data, common to all drops */
typedef struct {
    char client_name_prefix[16];    /**< "sss0-2aaa-aa" => append "bb-cc"  */
    char hw_id_prefix[19];          /**< "00:11:22:33:44:55:" => append "dd" */
    char ip_addr[16];               /**< The Client's IP address */
} msecp_cfg_misc;


void msecp_cfg_init(void);
u_int8_t msecp_cfg_get_dbg_level(void);
char *msecp_cfg_get_host1(void);
char *msecp_cfg_get_host2(void);
u_int16_t msecp_cfg_get_udpbase_port(void);
u_int8_t msecp_cfg_get_session_test(void);
u_int32_t msecp_cfg_get_tmo_cnt(void);
u_int32_t msecp_cfg_get_min_rsp_tmo(void);
u_int32_t msecp_cfg_get_max_rsp_tmo(void);

u_int16_t msecp_cfg_get_port(u_int8_t drop);
char *msecp_cfg_get_hwid(void);
char *msecp_cfg_get_client_id(void);

/*
 * End of "$Id: msecp_cfg.h,v 1.1 2004/07/12 18:03:47 tmeiccvs Exp $".
 */

























































































#endif /* __MSECP_RT_CFG_H__ */

/*
 * End of "$Id: msecp_cfg.h,v 1.1 2004/07/12 18:03:47 tmeiccvs Exp $".
 */


