#ifndef __MSECP_DBG_H__
#define __MSECP_DBG_H__

/* ===[ $RCSfile: msecp_dbg.h,v $ ]========================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2004 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: msecp_dbg.h,v 1.1 2004/07/12 18:03:47 tmeiccvs Exp $"
 *
 *  \brief Contains the MSECP debug API.
 */
/* ======================================================================= */

extern u_int8_t msecp_dbg_level;

/** msecp module debug level variable name */
#define MODULE_DEBUG_LEVEL  msecp_dbg_level
/** msecp's module name */
#define MODULE_NAME         "MSECP"

#include "debug.h"

/* === */
/* API */
/* === */
void msecp_dbg_init(int level);
void msecp_dbg_set_level(u_int8_t level);
u_int8_t msecp_dbg_get_level(void);
u_int32_t msecp_dbg_time(void);
void msecp_dbg_time_stamp(void);
void msecp_dbg_print_buf(buf_t b);

#endif /* __MSECP_DBG__H__ */


/*
 * End of "$Id: msecp_dbg.h,v 1.1 2004/07/12 18:03:47 tmeiccvs Exp $".
 */


