#ifndef __MSECP_FSM_H__
#define __MSECP_FSM_H__

/* ===[ $RCSfile: msecp_fsm.h,v $ ]========================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2004 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  $Id: msecp_fsm.h,v 1.2 2004/08/06 17:43:48 tmeiccvs Exp $
 *
 *  \brief Contains the MSECP Finite State Machine API.
 */
/* ======================================================================= */

/* === */
/* API */
/* === */
void msecp_fsm_init(void);

void msecp_fsm_process_app_rqst(u_int8_t drop, char *client_id, char *data, int data_len);
void msecp_fsm_process_proto_tmo(u_int8_t drop);
buf_t msecp_fsm_process_unicast(u_int8_t drop, buf_t b);

#endif /* __MSECP_FSM_H__ */


/*
 * End of $Id: msecp_fsm.h,v 1.2 2004/08/06 17:43:48 tmeiccvs Exp $
 */


