#ifndef __MSECP_IMP_H__
#define __MSECP_IMP_H__

/* ===[ $RCSfile: msecp_imp.h,v $ ]========================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2004 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: msecp_imp.h,v 1.1 2004/07/12 18:03:47 tmeiccvs Exp $"
 *
 *  \brief Contains the MSECP Inter-module Protocol (IMP) API .
 */
/* ======================================================================= */

/* =================== */
/* Function Prototypes */
/* =================== */
/* Misc. */
void msecp_imp_init(const char *local_q, const char *upper_q);

/* Outgoing IMP messages */

void msecp_imp_send_txdata_ind(u_int8_t drop);
void msecp_imp_send_rxdata(u_int8_t drop, u_int8_t *data, int length);

#endif /* __MSECP_IMP_H__ */


/*
 * End of "$Id: msecp_imp.h,v 1.1 2004/07/12 18:03:47 tmeiccvs Exp $".
 */


