#ifndef __MSECP_TMR_H__
#define __MSECP_TMR_H__

/* ===[ $RCSfile: msecp_tmr.h,v $ ]========================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2004 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: msecp_tmr.h,v 1.1 2004/07/12 18:03:47 tmeiccvs Exp $"
 *
 *  \brief Contains the MSECP timer API .
 */
/* ======================================================================= */

/* ======= */
/* Defines */
/* ======= */
#define MSECP_TMR_ID         MSECP_CFG_BASE_PORT /**< A unique MSECP timer ID */
#define MSECP_TMR_RESPONSE   1                   /**< Timer response type */
#define MSECP_TMR_KEEPALIVE  2                   /**< Timer keepalive type */
#define MSECP_TMR_DISABLE    3                   /**< Timer disable type */
#define MSECP_TMR_MAX_TIMER  MSECP_TMR_DISABLE   /**< Maximum timer type */
#define MSECP_NO_PREV_RESP_TIME          0xFFFF  /**< No prev response time */

/* === */
/* API */
/* === */
void msecp_tmr_init(void);
void msecp_tmr_start_resp(u_int8_t drop);
void msecp_tmr_start_keepalive(u_int8_t drop, u_int16_t sec);
void msecp_tmr_start_disable(u_int8_t drop, u_int16_t sec);
void msecp_tmr_stop_resp(u_int8_t drop);
void msecp_tmr_stop_keepalive(u_int8_t drop);
void msecp_tmr_stop_disable(u_int8_t drop);

u_int16_t msecp_tmr_get_id(u_int32_t tmr);
u_int8_t msecp_tmr_get_drop(u_int32_t tmr);
u_int8_t msecp_tmr_get_type(u_int32_t tmr);
int msecp_tmr_is_msecp_tmr(u_int32_t tmr);

u_int16_t msecp_tmr_get_prev_resp_time(u_int8_t drop);
void msecp_tmr_mark_end(u_int8_t drop);

#endif /* __MSECP_TMR_H__ */

/*
 * End of "$Id: msecp_tmr.h,v 1.1 2004/07/12 18:03:47 tmeiccvs Exp $".
 */
