#ifndef __MSECP_UDP_H__
#define __MSECP_UDP_H__

/* ===[ $RCSfile: msecp_udp.h,v $ ]========================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2004 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: msecp_udp.h,v 1.2 2004/08/06 17:41:47 tmeiccvs Exp $"
 *
 *  \brief Contains the MSECP UDP API.
 */
/* ======================================================================= */

/* === */
/* API */
/* === */
#define MSECP_UDP_PORT     0xFACE
void msecp_udp_init(void);
void msecp_udp_open(int drop);
void msecp_udp_send(u_int8_t drop, buf_t b);
void msecp_udp_use_next_host(u_int8_t drop);
void msecp_udp_multicast_join(char *address, u_int16_t *port);

#endif /* __MSECP_UDP_H__ */

/*
 * End of "$Id: msecp_udp.h,v 1.2 2004/08/06 17:41:47 tmeiccvs Exp $".
 */
