/* ===[ $RCSfile: pad.c,v $ ]=============================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2003 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: pad.c,v 1.2 2005/02/10 21:36:58 cmayncvs Exp $"
 *
 *  \brief Dummy drop for ES-PAD.  It sends a request, then waits for unsos.
 *
 *  This module serves as a dummy drop for the ES-PAD.  Knowing that the
 *  multi-drop esc module will not return a response or response timeout until
 *  it has successfully configured with the host, this module sends a single
 *  request to mesc so that the pad itself can be configured and appear as a
 *  drop to ES-ADMIN.
 *
 *  Once configured, this module then only listens for unsolicited messages
 *  being sent from the host.  More specifically, it listens for unsolicited
 *  reset messages.  If either a soft, hard, or ultimate reset is received,
 *  whether broadcast or unicast, the pad will wait for 1 second (to give the
 *  x42pp module a chance to send the unsolicited reset message to all of the
 *  drops), then it will simply reset the Cyclades box.  All reset types are
 *  handled the same way - as a SOFT reset.
 *
 *  The module uses defines from the mesc code, and in particular, assumes
 *  the identity of MESC_CFG_MAX_DROPS - 1.
 */
/* ======================================================================= */

/* ============= */
/* Include Files */
/* ============= */
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include "libcom/buf.h"
#include "libcom/mq.h"
#include "libcom/msg.h"
#include "pad.h"
#include "pad_imp.h"
#include "mesc/mesc_cfg.h"
#include "gdebug.h"
#include "gassert.h"

/** The debug level for the pad */
u_int8_t pad_dbg_level = PRINT_LEVEL;

/* ======================================================================= */
/**
 *  \brief PAD entry point.
 *  \param argc Should be 2 or 3.  More than 3 are ignored.
 *  \param argv - argv[1]=local queue, argv[2]=lower queue, optional argv[3]
 *      holds the debug level.
 *
 *  \return Never returns - only REBOOTS!
 */
/* ======================================================================= */
int main(int argc, char *argv[])
{
    int sap = 1;
    u_int8_t drop = PAD_DROP_ADDRESS;

    if ( argc < 3 )
    {
        info("Usage: pad <local_queue> <lower_queue> [-d dbglvl]\n");
        exit(0);
    }
    assert(argv && argv[1] && argv[2]);             /* appease lint */
    info("pad(%d) Started.", getpid());
    pad_imp_init(argv[1], argv[2]);

    /* Send a single empty request then simply wait for a reset unso */
    pad_imp_send_rqst(NULL, 0, sap, drop);
    info("Listening for unsolicited reset messages...\n");
    while ( 1 )
        msg_dispatch(mq_read());

    return (0);

} /* main() */


/*
 * End of "$Id: pad.c,v 1.2 2005/02/10 21:36:58 cmayncvs Exp $".
 */


