/* ===[ $RCSfile: line-monitor.c,v $ ]=============================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2003 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: line-monitor.c,v 1.2 2005/02/09 17:40:02 cmayncvs Exp $"
 *
 * \brief Line monitor functions.
 *
 * A second debug log is used for line monitor output (/dev/line_monitor).
 *
 */
#include <stdio.h>
#include <string.h>
#include <termios.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "gassert.h"

#define TX_PREFIX   "\nTx: "    /**< Transmit prefix */
#define RX_PREFIX   "\nRx: "    /**< Receive prefix */

/** Log file descriptor */
static int fd;
/** True: write RX_PREFIX next write. */
static int write_rx_prefix = 1;

/**
 * \brief Initialize line monitor.
 */
void
lm_init (void)
{
    assert ((fd = open ("/dev/line_monitor", O_RDWR)) != -1);
}

/**
 * \brief Write TX data.
 * \param data Pointer to data.
 * \param length Data length.
 */
void
lm_tx_data (unsigned char *data, int length)
{
    int i, newline_cnt = 0;
    char b[20];

    write_rx_prefix = 1;
    write (fd, TX_PREFIX, strlen (TX_PREFIX));
    for (i = 0; i < length; i++)
    {
        if (newline_cnt == 16)
        {
            write (fd, "\n", 1);
            newline_cnt = 0;
        }
        snprintf (b, sizeof (b), "%2.2X ", data[i]);
        write (fd, b, strlen (b));
    }
}

/**
 * \brief Write RX data.
 * \param data Pointer to data.
 * \param length Data length.
 */
void
lm_rx_data (unsigned char *data, int length)
{
    int i;
    char b[20];
    static int newline_cnt = 0;

    if (write_rx_prefix)
    {
        write (fd, RX_PREFIX, strlen (RX_PREFIX));
        write_rx_prefix = 0;
    }
    for (i = 0; i < length; i++)
    {
        if (newline_cnt == 16)
        {
            write (fd, "\n", 1);
            newline_cnt = 0;
        }
        snprintf (b, sizeof (b), "%2.2X ", data[i]);
        write (fd, b, strlen (b));
    }
}

/*
 * End of "$Id: line-monitor.c,v 1.2 2005/02/09 17:40:02 cmayncvs Exp $".
 */

