/* ===[ $RCSfile: stty_cfg.c,v $ ]=============================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2003 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: stty_cfg.c,v 1.1 2004/01/26 18:23:00 gspatcvs Exp $"
 *
 *  \brief STTY configuration interface.
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "libcom/c_config.h"
#include "stty_debug.h"
#include "stty_cfg_structs.h"
#include "stty_cfg.h"

/** Current configuration */
static struct stty_cfg cfg;

/**
 * \brief Print current configuration.
 */
static void
print_cfg (void)
{
    info ("Current Configuration");
    info ("Media Type           -> %s", cfg.media == RS232 ? "RS232" : "RS485");
}

/**
 * \brief Read in and print config.
 */
void
stty_cfg_init (void)
{
    c_config_read (STTY_CFG_RECORD, &cfg, &stty_default_cfg, sizeof (struct stty_cfg));
    print_cfg ();
}

/**
 * Get stty media type.
 * \return Media type.
 */
int
stty_cfg_get_media (void)
{
    return cfg.media;
}

/*
 * End of "$Id: stty_cfg.c,v 1.1 2004/01/26 18:23:00 gspatcvs Exp $".
 */

