#ifndef STTYCFGSTRUCTSH
#define STTYCFGSTRUCTSH

/* ===[ $RCSfile: stty_cfg_structs.h,v $ ]===================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2002-2005 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file

  $Id: stty_cfg_structs.h,v 1.4 2005/07/11 19:41:09 cmayncvs Exp $

 \brief The STTY config struct definitions file.
 */
#define RS232   0   /**< Serial port configuration for RS-232 */
#define RS485   11  /**< Serial port configuration for RS-485 */

#define STTY_CFG_RECORD    "STTY"   /**< Stty configuration file name */

/** \brief Stty configuration structure. */
struct stty_cfg
{
    int media;      /**< The media as either RS232 or RS485. */
};
/** \brief Stty default configuration data. */
static struct stty_cfg stty_default_cfg =
{
    media: RS232                    /**< Default media type. */
};

#endif /* STTYCFGSTRUCTSH */


/*
 * End of "$Id: stty_cfg_structs.h,v 1.4 2005/07/11 19:41:09 cmayncvs Exp $".
 */


