/* ===[ $RCSfile: dbglvl.c,v $ ]==========================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2002-2005 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: dbglvl.c,v 1.3 2005/03/22 20:21:49 cmayncvs Exp $"
 *
 *  \brief Separate program for changing run-time debug level of any comm
 *      process that handles IMP messages.
 */
/* ======================================================================= */

/* ============= */
/* Include Files */
/* ============= */
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <string.h>
#include "libcom/buf.h"
#include "libcom/mq.h"
#include "libcom/msg.h"
#include "gdebug.h"
#include "gassert.h"

/*=========*/
/* Defines */
/*=========*/


/*==========*/
/* Typedefs */
/*==========*/


/*=============================*/
/* Local functions & variables */
/*=============================*/


/* ======= */
/* Globals */
/* ======= */


/* ======================================================================= */
/**
 *  \brief Sends an IMP message to the specified queue to change the run-time
 *      debug level.  If queue name is "all", sends to all.
 *  \param argc The number of parametes - should be 3
 *  \param argv Holds 2 parameters - one for the queue to send to, the other
 *      for the debug level.
 *
 *  \return 0, always
 */
/* ======================================================================= */
int main(int argc, char *argv[])
{
    buf_t imp_buf;
    u_int8_t level;

    if ( argc < 3 )
    {
        printf("Usage: dbglvl <queue> <debug level>\n\n");
        printf("  <queue> is one of following:\n");
        printf("    devcomm        gtp            x42            x25\n");
        printf("    serial-if      udp-interface  esc            conman\n");
        printf("    stty           x42pp          escp           pad\n");
        printf("    ethmon         all\n\n");
        printf("  <debug level> is one of the following:\n");
        printf("    0 = DBG_NONE,  1 = DBG_ALL,   2 = DBG_INFO4, 3 = DBG_INFO3,\n");
        printf("    4 = DBG_INFO2, 5 = DBG_INFO1, 6 = DBG_WARN,  7 = DBG_ERR\n\n");
        printf("  ...which map internally to comm debug levels as:\n");
        printf("    DBG_NONE             = NONE\n");
        printf("    DBG_ALL,   DBG_INFO4 = PRINT\n");
        printf("    DBG_INFO3, DBG_INFO2 = TRACE\n");
        printf("    DBG_INFO1            = INFO\n");
        printf("    DBG_WARN,  DBG_ERR   = WARN\n\n");
        exit (0);
    }
    assert(argv && argv[1] && argv[2]);     /* appease lint */

    level = strtol(argv[2], NULL, 0) & 0x07;

    /* Build the message */
    if ( !strcmp("all", argv[1]) )
    {
        imp_buf = msg_create("broadcast", "debug", "set-debug-level");
        imp_buf = msg_add_field(imp_buf, "level", (char *)&level, 1);

        /* Send it */
        mq_broadcast(imp_buf);
    }
    else if ( mq_is_a_queue(argv[1]) )
    {
        imp_buf = msg_create(argv[1], "debug", "set-debug-level");
        imp_buf = msg_add_field(imp_buf, "level", (char *)&level, 1);

        /* Send it */
        mq_write(argv[1], imp_buf);
    }
    else    /* invalid queue name */
    {
        printf("<<<ERROR>>> Bad queue name: %s\n\n", argv[1]);
        exit (0);
    }

    return (0);
} /* main() */


/*
 * End of "$Id: dbglvl.c,v 1.3 2005/03/22 20:21:49 cmayncvs Exp $".
 */


