/* ===[ $RCSfile: reset-terminal.c,v $ ]=====================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2002-2005 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file

  $Id: reset-terminal.c,v 1.2 2005/02/09 17:51:22 cmayncvs Exp $

 \brief Utility for sending a soft, hard, or ultimate reset to a terminal.
 */
#include <stdio.h>
#include <string.h>
#include "libcom/buf.h"
#include "libcom/msg.h"
#include "libcom/mq.c"

/**
 *  \brief Reset utility main entry point.
 *  \param argc The number of arguments.
 *  \param argv The list of arguments.
 *  \return 0, always.
 */
int
main (int argc, char **argv)
{
    buf_t b;
    unsigned char drop;
    char soft[] = {0x30, 0x77};
    char hard[] = {0x30, 0x75};
    char ult[] = {0x30, 0x79, 0x4A};

    if (argc < 2)
    {
        printf ("Usage: reset-terminal drop <type: s, h, u>\n");
        exit (-1);
    }

    drop = strtol (argv[1], 0, 10);

    b = msg_create ("x42pp", "reset-terminal", "unsolicited-data");
    b = msg_add_field (b, "drop", &drop, 1);
    if (argc < 3)
    {
        printf ("Sending Soft Reset\n");
        msg_add_field (b, "data", soft, sizeof (soft));
    }
    else
    {
        if (strcmp (argv[2], "s") == 0)
            msg_add_field (b, "data", soft, sizeof (soft));
        else if (strcmp (argv[2], "h") == 0)
            msg_add_field (b, "data", hard, sizeof (hard));
        else if (strcmp (argv[2], "u") == 0)
            msg_add_field (b, "data", ult, sizeof (ult));
        else
        {
            printf ("Unknown reset type: %s\n", argv[2]);
            exit (-1);
        }
    }
    mq_write ("x42pp", b);

    return 0;
}


/*
 * End of "$Id: reset-terminal.c,v 1.2 2005/02/09 17:51:22 cmayncvs Exp $".
 */


