/* ===[ $RCSfile: x42pp.c,v $ ]=============================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2003 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: x42pp.c,v 1.2 2005/02/09 23:29:06 cmayncvs Exp $"
 *
 *  \brief X42pp main application.
 *
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include "libcom/buf.h"
#include "x42pp_types.h"
#include "x42pp_debug.h"
#include "x42pp_cfg.h"
#include "x42pp_rx.h"
#include "x42pp_tx.h"
#include "x42pp_imp.h"
#include "x42pp_status.h"

/**
*  \brief Initializes the debug facility and redirects stdout, stderr.
*  \return Nothing.
*/
static void
debug_init (void)
{
    int debug_fd;

    if ( (debug_fd = open ("/dev/debug_log", O_WRONLY)) != -1 )
    {
        dup2(debug_fd, STDOUT_FILENO);
        dup2(debug_fd, STDERR_FILENO);
    }
    else
    {
        warn ("Failed to open debug log: %s", strerror (errno));
    }
}

/**
 * \brief GTP main function.
 * \param argc Number of arguements.
 * \param argv List of arguements.
 * \return Never returns.
 */
int
main (int argc, char *argv[])
{
    char *self, *upper, *lower;

    if (argc < 4)
    {
        self = "x42pp";
        upper = "escp";
        lower = "stty";
        //lower = "escp";
    }
    else
    {
        self = argv[1];
        upper = argv[2];
        lower = argv[3];
    }

    debug_init ();
    x42pp_status_init ();
    x42pp_cfg_init ();
    x42pp_rx_init (x42pp_cfg_get_poll_tmo ());
    x42pp_tx_init (x42pp_cfg_get_drop_list (), MAX_DROPS, x42pp_cfg_get_poll_tmo ());
    x42pp_imp_init (self, upper, lower, x42pp_cfg_get_port (), x42pp_cfg_get_baud_rate ());

    return 0;
}

/*
 * End of "$Id: x42pp.c,v 1.2 2005/02/09 23:29:06 cmayncvs Exp $".
 */

