/* ===[ $RCSfile: x42pp_cfg.c,v $ ]=============================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2003 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: x42pp_cfg.c,v 1.1.1.1 2003/12/02 15:53:30 sbobcvs Exp $"
 *
 *  \brief X42pp configuration interface.
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "libcom/c_config.h"
#include "x42pp_types.h"
#include "x42pp_debug.h"
#include "x42pp_cfg_structs.h"
#include "x42pp_cfg.h"

/** Current configuration */
static struct x42pp_cfg cfg;

/**
 * \brief Print current configuration.
 */
static void
print_cfg (void)
{
    int i, c;

    for (i = 0, c = 0; i < MAX_DROPS; i++)
        if (cfg.drop_list[i]) c++;

    info ("Current Configuration");
    info ("Configured Drops     -> %d", c);
    info ("Poll Timeout         -> %ld ms", cfg.poll_tmo);
    info ("Port                 -> %s", cfg.port);
    info ("Baud Rate            -> %s", cfg.baud_rate);
}

/**
 * \brief Read in and print config.
 */
void
x42pp_cfg_init (void)
{
    c_config_read (X42PP_CFG_RECORD, &cfg, &default_cfg, sizeof (struct x42pp_cfg));
    print_cfg ();
}

/**
 * \brief Get list of drops to poll.
 * \return Drop list.
 */
ubyte_1 *
x42pp_cfg_get_drop_list (void)
{
    return cfg.drop_list;
}

/**
 * \brief Get poll timeout.
 * \return Poll timeout.
 */
ubyte_4
x42pp_cfg_get_poll_tmo (void)
{
    return cfg.poll_tmo;
}

/**
 * \brief Get x42pp port.
 * \return Port string.
 */
char *
x42pp_cfg_get_port (void)
{
    return cfg.port;
}

/**
 * Get x42pp baud rate.
 * \return Baud rate string.
 */
char *
x42pp_cfg_get_baud_rate (void)
{
    return cfg.baud_rate;
}

/*
 * End of "$Id: x42pp_cfg.c,v 1.1.1.1 2003/12/02 15:53:30 sbobcvs Exp $".
 */

