#ifndef X42PPCFGSTRUCTSH
#define X42PPCFGSTRUCTSH

/* ===[ $RCSfile: x42pp_cfg_structs.h,v $ ]===============================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2002-2005 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: x42pp_cfg_structs.h,v 1.3 2005/02/09 23:27:36 cmayncvs Exp $
 *
 *  \brief The ESPAD X.42 polling processor config structure definitions file.
 */
/* ======================================================================= */
#include "x42pp_types.h"

#define X42PP_CFG_RECORD    "X4PP"  /**< X.42 Configuration file name */

/** \brief Structure for X.42 configuration information. */
struct x42pp_cfg
{
    ubyte_1 drop_list [MAX_DROPS];  /**< The list of drops to poll */
    ubyte_4 poll_tmo;               /**< The poll timeout (ms) */
    char    port [15];              /**< The configured serial port */
    char    baud_rate [15];         /**< The configured baud rate */
};
/** Default x42pp parameters */
static struct x42pp_cfg default_cfg =
{
    drop_list: {[0 ... 1] = 1, [2 ... (MAX_DROPS -1)] = 0}, /**< default active poll list */
    poll_tmo: 50,           /**< default poll timeout (ms) */
    port: "port1",          /**< default port */
    baud_rate: "19200"      /**< default baud rate */
};

#endif /* X42PPCFGSTRUCTSH */


/*
 * End of "$Id: x42pp_cfg_structs.h,v 1.3 2005/02/09 23:27:36 cmayncvs Exp $".
 */


