/* ===[ $RCSfile: x42pp_debug.c,v $ ]=============================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2002 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file

 $Id: x42pp_debug.c,v 1.1.1.1 2003/12/02 15:53:30 sbobcvs Exp $

 \brief Implements debug functions.
 */

#include <sys/time.h>
#include "x42pp_debug.h"

/** Debug level. */
unsigned char x42pp_debug_level = WARN_LEVEL | INFO_LEVEL | TRACE_LEVEL | PRINT_LEVEL;

/**
 * \brief Set debug level.
 * \param level Debug level.
 */
void
x42pp_debug_set_level (unsigned char level)
{
    x42pp_debug_level = level;
    warn ("Debug level changed to %X", x42pp_debug_level);
}

/**
 * \brief Get current time.
 * \return Time in milliseconds.
 */
unsigned int
x42pp_debug_time (void)
{
    struct timeval t;

    gettimeofday (&t, 0);
    return (unsigned int)((t.tv_sec*1000)+(t.tv_usec/1000));
}

/**
 * \brief Print current time.
 */
void
x42pp_debug_time_stamp (void)
{
    info ("Time is %u", x42pp_debug_time ());
}

/*
 * End of $Id: x42pp_debug.c,v 1.1.1.1 2003/12/02 15:53:30 sbobcvs Exp $
 */

