#ifndef X42PPDEBUGH
#define X42PPDEBUGH

/* ===[ $RCSfile: x42pp_debug.h,v $ ]========================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2002 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file

 $Id: x42pp_debug.h,v 1.2 2005/02/09 23:27:36 cmayncvs Exp $

 \brief Debug functions API.
 */
#include "stdio.h"

extern unsigned char x42pp_debug_level;

/** mesc module debug level variable name */
#define MODULE_DEBUG_LEVEL  x42pp_debug_level
/** mesc's module name */
#define MODULE_NAME         "X42PP"

#include "debug.h"

#if 0
#define WARN_LEVEL      (0x01)
#define INFO_LEVEL      (0x02)
#define TRACE_LEVEL     (0x03)
#define PRINT_LEVEL     (0x04)

#define warn(fmt,args...) \
    if (x42pp_debug_level >= WARN_LEVEL){ \
        printf ("X42pp (%s %d) ***WARNING***: " fmt "\n", \
            __FILE__ , __LINE__  , ##args); \
        fflush (stdout); }

#define info(fmt,args...) \
    if (x42pp_debug_level >= INFO_LEVEL){ \
        printf ("X42pp (%s %d): " fmt "\n", \
           __FILE__ , __LINE__  , ##args); \
        fflush (stdout); }

#define trace(fmt,args...) \
    if (x42pp_debug_level >= TRACE_LEVEL){ \
        printf ("X42pp (%s %d): " fmt "\n", \
            __FILE__ , __LINE__  , ##args); \
        fflush (stdout); }

#define print(fmt,args...) \
    if (x42pp_debug_level >= PRINT_LEVEL){ \
        printf (fmt , ##args); \
        fflush (stdout); }
#endif

void
x42pp_debug_set_level (unsigned char level);

unsigned int
x42pp_debug_time (void);

void
x42pp_debug_time_stamp (void);

#endif /* X42PPDEBUGH */


/*
 * End of "$Id: x42pp_debug.h,v 1.2 2005/02/09 23:27:36 cmayncvs Exp $".
 */


