#ifndef X42PPIMPH
#define X42PPIMPH

/* ===[ $RCSfile: x42pp_imp.h,v $ ]==========================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2003-2005 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: x42pp_imp.h,v 1.3 2005/02/09 23:27:36 cmayncvs Exp $"
 *
 * \brief X42pp IMP interface API.
 *
 * X42pp takes the place of Devcom in the standard modules. X42pp sends and
 * receives data as if it was an application. An optional IMP field, "drop",
 * has been added to support multiple terminals.
 *
 */
#include "libcom/buf.h"

void
x42pp_imp_send_frame (buf_t frame);

void
x42pp_imp_sreq (ubyte_1 drop, char *data, int length);

void
x42pp_imp_init (char *self, char *upper, char *lower, char *port, char *baud_rate);

void
x42pp_imp_send_empty (ubyte_1 drop);

void
x42pp_imp_send_drop_status (ubyte_1 drop, char *status);

#endif /* X42PPIMPH */


/*
 * End of "$Id: x42pp_imp.h,v 1.3 2005/02/09 23:27:36 cmayncvs Exp $".
 */


