#ifndef X42PPRXH
#define X42PPRXH

/* ===[ $RCSfile: x42pp_rx.h,v $ ]===========================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2003-2005 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: x42pp_rx.h,v 1.2 2005/02/09 23:27:36 cmayncvs Exp $"
 *
 * \brief X42pp Recieve State Machine API.
 *
 * The RX state machine is started by the TX state machine after all data is
 * finished being transmitted by the serial port. The poll timer is restarted
 * after every valid character received.
 *
 */
/** X.42pp receive timer indicator */
#define X42PP_RX    ('R' << 8)

void
x42pp_rx_init (ubyte_4 poll_tmo);

void
x42pp_rx_reset (ubyte_1 address, ubyte_1 type);

void
x42pp_rx_ind (ubyte_1 *data, ubyte_2 length);

void
x42pp_rx_poll_tmo (ubyte_1 drop);

#endif /* X42PPRXH */


/*
 * End of "$Id: x42pp_rx.h,v 1.2 2005/02/09 23:27:36 cmayncvs Exp $".
 */


