/* ===[ $RCSfile: x42pp_status.c,v $ ]=============================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2003 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: x42pp_status.c,v 1.4 2005/02/09 23:36:37 cmayncvs Exp $"
 *
 * \brief Keep track of x42pp drop status.
 *
 * A drop can be in one of five states:
 *
 * 1. Polling
 * 2. Slow polling
 * 3. Pending transaction.
 * 4. Disabled.
 * 5. Not configured.
 *
 */
#include <stdio.h>
#include "libcom/stats.h"
#include "x42pp_status_structs.h"
#include "x42pp_imp.h"

/** Current Status */
static struct x42pp_status status;

/**
 * \brief Set drop status polling.
 * \param drop Drop to set.
 */
void
x42pp_status_polling (int drop)
{
    if (status.drop_status [drop] == SLOW_POLL)
        x42pp_imp_send_drop_status (drop, "polling");

    status.drop_status [drop] = POLLING;
}

/**
 * \brief Set drop status slow polling.
 * \param drop Drop to set.
 */
void
x42pp_status_slow_poll (int drop)
{
    if (status.drop_status [drop] != SLOW_POLL)
        x42pp_imp_send_drop_status (drop, "slow-polling");

    status.drop_status [drop] = SLOW_POLL;
}

/**
 * \brief Set drop status pending.
 * \param drop Drop to set.
 */
void
x42pp_status_pending (int drop)
{
    status.drop_status [drop] = PENDING;
}

/**
 * \brief Set drop status disabled.
 * \param drop Drop to set.
 */
void
x42pp_status_disabled (int drop)
{
    status.drop_status [drop] = DISABLED;
}

/**
 * \brief Initialize status.
 */
void
x42pp_status_init (void)
{
    int i;

    for (i = 0; i < MAX_DROPS; i++)
        status.drop_status [i] = NOT_CFG;

    /* Add hook to allow other processes to get the status. */
    stats_add_struct_writer (&status, sizeof (status));
}

/*
 * End of "$Id: x42pp_status.c,v 1.4 2005/02/09 23:36:37 cmayncvs Exp $".
 */

