#ifndef X42PPSTATUSSTRUCTSH
#define X42PPSTATUSSTRUCTSH

/* ===[ $RCSfile: x42pp_status_structs.h,v $ ]===============================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2002-2005 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: x42pp_status_structs.h,v 1.2 2005/02/09 17:35:27 cmayncvs Exp $
 *
 *  \brief The ESPAD X.42 polling processor status structure definitions file.
 */
/* ======================================================================= */
#include "x42pp/x42pp_types.h"

#define NOT_CFG     0   /**< Drop is not configured */
#define POLLING     1   /**< Drop is responding to polls */
#define SLOW_POLL   2   /**< Drop is in slow poll list */
#define PENDING     3   /**< Drop has a pending transaction */
#define DISABLED    4   /**< Drop is disabled */

/** \brief Structure for X.42 drop status */
struct x42pp_status
{
    char drop_status [MAX_DROPS];   /**< Drop status */
};

#endif /* X42PPSTATUSSTRUCTSH */


/*
 * End of "$Id: x42pp_status_structs.h,v 1.2 2005/02/09 17:35:27 cmayncvs Exp $".
 */


